/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.json;

import com.djrapitops.plan.delivery.rendering.json.PlayerJSONCreator;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.identification.Identifiers;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlayerJSONResolver
implements Resolver {
    private final Identifiers identifiers;
    private final PlayerJSONCreator jsonCreator;

    @Inject
    public PlayerJSONResolver(Identifiers identifiers, PlayerJSONCreator jsonCreator) {
        this.identifiers = identifiers;
        this.jsonCreator = jsonCreator;
    }

    @Override
    public boolean canAccess(Request request) {
        WebUser user = request.getUser().orElse(new WebUser(""));
        UUID playerUUID = this.identifiers.getPlayerUUID(request);
        UUID webUserUUID = this.identifiers.getPlayerUUID(user.getName());
        boolean isOwnPage = playerUUID.equals(webUserUUID);
        return user.hasPermission("page.player.other") || user.hasPermission("page.player.self") && isOwnPage;
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return Optional.of(this.getResponse(request));
    }

    private Response getResponse(Request request) {
        UUID playerUUID = this.identifiers.getPlayerUUID(request);
        return Response.builder().setMimeType("application/json").setJSONContent(this.jsonCreator.createJSONAsMap(playerUUID)).build();
    }
}

