/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.json;

import com.djrapitops.plan.delivery.rendering.json.JSONFactory;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.identification.Identifiers;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlayersTableJSONResolver
implements Resolver {
    private final Identifiers identifiers;
    private final JSONFactory jsonFactory;

    @Inject
    public PlayersTableJSONResolver(Identifiers identifiers, JSONFactory jsonFactory) {
        this.identifiers = identifiers;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public boolean canAccess(Request request) {
        WebUser user = request.getUser().orElse(new WebUser(""));
        if (request.getQuery().get("server").isPresent()) {
            return user.hasPermission("page.server");
        }
        return user.hasPermission("page.players");
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return Optional.of(this.getResponse(request));
    }

    private Response getResponse(Request request) {
        if (request.getQuery().get("server").isPresent()) {
            UUID serverUUID = this.identifiers.getServerUUID(request);
            return JSONCache.getOrCache(DataID.PLAYERS, serverUUID, () -> this.jsonFactory.serverPlayersTableJSON(serverUUID));
        }
        return JSONCache.getOrCache(DataID.PLAYERS, this.jsonFactory::networkPlayersTableJSON);
    }
}

