/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.json;

import com.djrapitops.plan.delivery.rendering.json.JSONFactory;
import com.djrapitops.plan.delivery.rendering.json.OnlineActivityOverviewJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.PerformanceJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.PlayerBaseOverviewJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.PvPPvEJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.ServerOverviewJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.ServerTabJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.SessionsOverviewJSONCreator;
import com.djrapitops.plan.delivery.web.resolver.CompositeResolver;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.resolver.json.GraphsJSONResolver;
import com.djrapitops.plan.delivery.webserver.resolver.json.NetworkJSONResolver;
import com.djrapitops.plan.delivery.webserver.resolver.json.PlayerJSONResolver;
import com.djrapitops.plan.delivery.webserver.resolver.json.PlayerKillsJSONResolver;
import com.djrapitops.plan.delivery.webserver.resolver.json.PlayersTableJSONResolver;
import com.djrapitops.plan.delivery.webserver.resolver.json.ServerTabJSONResolver;
import com.djrapitops.plan.delivery.webserver.resolver.json.SessionsJSONResolver;
import com.djrapitops.plan.identification.Identifiers;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class RootJSONResolver {
    private final Identifiers identifiers;
    private final CompositeResolver resolver;

    @Inject
    public RootJSONResolver(Identifiers identifiers, JSONFactory jsonFactory, GraphsJSONResolver graphsJSONResolver, SessionsJSONResolver sessionsJSONResolver, PlayersTableJSONResolver playersTableJSONResolver, ServerOverviewJSONCreator serverOverviewJSONCreator, OnlineActivityOverviewJSONCreator onlineActivityOverviewJSONCreator, SessionsOverviewJSONCreator sessionsOverviewJSONCreator, PlayerKillsJSONResolver playerKillsJSONResolver, PvPPvEJSONCreator pvPPvEJSONCreator, PlayerBaseOverviewJSONCreator playerBaseOverviewJSONCreator, PerformanceJSONCreator performanceJSONCreator, PlayerJSONResolver playerJSONResolver, NetworkJSONResolver networkJSONResolver) {
        this.identifiers = identifiers;
        this.resolver = CompositeResolver.builder().add("players", playersTableJSONResolver).add("sessions", sessionsJSONResolver).add("kills", playerKillsJSONResolver).add("graph", graphsJSONResolver).add("pingTable", this.forJSON(DataID.PING_TABLE, jsonFactory::pingPerGeolocation)).add("serverOverview", this.forJSON(DataID.SERVER_OVERVIEW, serverOverviewJSONCreator)).add("onlineOverview", this.forJSON(DataID.ONLINE_OVERVIEW, onlineActivityOverviewJSONCreator)).add("sessionsOverview", this.forJSON(DataID.SESSIONS_OVERVIEW, sessionsOverviewJSONCreator)).add("playerVersus", this.forJSON(DataID.PVP_PVE, pvPPvEJSONCreator)).add("playerbaseOverview", this.forJSON(DataID.PLAYERBASE_OVERVIEW, playerBaseOverviewJSONCreator)).add("performanceOverview", this.forJSON(DataID.PERFORMANCE_OVERVIEW, performanceJSONCreator)).add("player", playerJSONResolver).add("network", networkJSONResolver.getResolver()).build();
    }

    private <T> ServerTabJSONResolver<T> forJSON(DataID dataID, ServerTabJSONCreator<T> tabJSONCreator) {
        return new ServerTabJSONResolver<T>(dataID, this.identifiers, tabJSONCreator);
    }

    public CompositeResolver getResolver() {
        return this.resolver;
    }
}

