/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.json;

import com.djrapitops.plan.delivery.rendering.json.ServerTabJSONCreator;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.identification.Identifiers;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public class ServerTabJSONResolver<T>
implements Resolver {
    private final DataID dataID;
    private final Identifiers identifiers;
    private final Function<UUID, T> jsonCreator;

    public ServerTabJSONResolver(DataID dataID, Identifiers identifiers, ServerTabJSONCreator<T> jsonCreator) {
        this.dataID = dataID;
        this.identifiers = identifiers;
        this.jsonCreator = jsonCreator;
    }

    @Override
    public boolean canAccess(Request request) {
        return request.getUser().orElse(new WebUser("")).hasPermission("page.server");
    }

    @Override
    public Optional<Response> resolve(Request request) {
        UUID serverUUID = this.identifiers.getServerUUID(request);
        return Optional.of(JSONCache.getOrCache(this.dataID, serverUUID, () -> this.jsonCreator.apply(serverUUID)));
    }
}

