/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.exceptions.database;

import com.djrapitops.plan.exceptions.ExceptionWithContext;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import java.sql.SQLException;
import java.util.Optional;

public class DBOpException
extends IllegalStateException
implements ExceptionWithContext {
    private ErrorContext context;

    public DBOpException(String message) {
        super(message);
    }

    public DBOpException(String message, Throwable cause) {
        super(message, cause);
    }

    public DBOpException(String message, Throwable cause, ErrorContext context) {
        super(message, cause);
        this.context = context;
    }

    public static DBOpException forCause(String sql, SQLException e) {
        ErrorContext.Builder context = ErrorContext.builder();
        int errorCode = e.getErrorCode();
        context.related((Object)("Error code: " + errorCode)).related((Object)sql);
        switch (errorCode) {
            case 10: 
            case 523: {
                context.related((Object)"SQL Corrupted").whatToDo("Your SQLite has corrupted. This can happen if .db-wal or .db-shm files get replaced mid operation. Restore database.db from backup.");
                break;
            }
            case 1054: 
            case 1064: 
            case 1146: 
            case 42000: 
            case 42001: 
            case 42101: 
            case 42102: 
            case 42111: 
            case 42112: 
            case 42121: 
            case 42122: 
            case 42132: {
                context.related((Object)"SQL Grammar error").whatToDo("Report this, there is an SQL grammar error.");
                break;
            }
            case 20: {
                context.related((Object)"SQL Type mismatch").whatToDo("Report this, there is an SQL Type mismatch.");
                break;
            }
            case 1062: 
            case 23001: 
            case 23505: {
                context.related((Object)"Duplicate key").whatToDo("Report this, duplicate key exists in SQL.");
                break;
            }
            case 19: 
            case 275: 
            case 531: 
            case 630: 
            case 787: 
            case 839: 
            case 840: 
            case 893: 
            case 1043: 
            case 1169: 
            case 1215: 
            case 1216: 
            case 1217: 
            case 1299: 
            case 1364: 
            case 1451: 
            case 1555: 
            case 1557: 
            case 1811: 
            case 2067: 
            case 2323: 
            case 2579: 
            case 22001: 
            case 22003: 
            case 22012: 
            case 22018: 
            case 22025: 
            case 23000: 
            case 23002: 
            case 23502: 
            case 23506: 
            case 23507: 
            case 23513: {
                context.related((Object)"Constraint Violation").whatToDo("Report this, there is an SQL Constraint Violation.");
                break;
            }
            default: {
                context.related((Object)"Unknown SQL Error code");
            }
        }
        return new DBOpException("SQL Failure: " + e.getMessage(), e, context.build());
    }

    @Override
    public Optional<ErrorContext> getContext() {
        return Optional.ofNullable(this.context);
    }
}

