/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension;

import java.util.ArrayList;

public enum ElementOrder {
    VALUES,
    GRAPH,
    TABLE;


    public static String serialize(ElementOrder[] order) {
        StringBuilder builder = new StringBuilder();
        int length = order.length;
        for (int i = 0; i < length; ++i) {
            builder.append(order[i].name());
            if (i >= length - 1) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public static ElementOrder[] deserialize(String serializedOrder) {
        if (serializedOrder == null || serializedOrder.isEmpty()) {
            return null;
        }
        String[] split = serializedOrder.split(",");
        ArrayList<ElementOrder> order = new ArrayList<ElementOrder>();
        for (String elementName : split) {
            try {
                ElementOrder element = ElementOrder.valueOf(elementName);
                order.add(element);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return order.toArray(new ElementOrder[0]);
    }
}

