/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension;

import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.exceptions.DataExtensionMethodCallException;
import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.Caller;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.ExtensionService;
import com.djrapitops.plan.extension.implementation.CallerImplementation;
import com.djrapitops.plan.extension.implementation.ExtensionRegister;
import com.djrapitops.plan.extension.implementation.ExtensionWrapper;
import com.djrapitops.plan.extension.implementation.providers.MethodWrapper;
import com.djrapitops.plan.extension.implementation.providers.gathering.ProviderValueGatherer;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.config.ExtensionSettings;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ExtensionSvc
implements ExtensionService {
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Processing processing;
    private final ExtensionRegister extensionRegister;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private final Map<String, ProviderValueGatherer> extensionGatherers;

    @Inject
    public ExtensionSvc(PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, Processing processing, ExtensionRegister extensionRegister, PluginLogger logger, ErrorLogger errorLogger) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.processing = processing;
        this.extensionRegister = extensionRegister;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.extensionGatherers = new HashMap<String, ProviderValueGatherer>();
    }

    public void register() {
        ExtensionService.Holder.set(this);
    }

    public void registerExtensions() {
        try {
            this.extensionRegister.registerBuiltInExtensions(this.config.getExtensionSettings().getDisabled());
        }
        catch (IllegalStateException failedToRegisterOne) {
            ErrorContext.Builder context = ErrorContext.builder().whatToDo("Report and/or disable the failed extensions. You can find the failed extensions in the error file.");
            for (Throwable suppressedException : failedToRegisterOne.getSuppressed()) {
                context.related((Object)suppressedException.getMessage());
            }
            this.logger.warn("One or more extensions failed to register (They can be disabled in Plan config).");
            this.errorLogger.log(L.WARN, failedToRegisterOne, context.build());
        }
    }

    @Override
    public Optional<Caller> register(DataExtension extension) {
        ExtensionWrapper extractor = new ExtensionWrapper(extension);
        String pluginName = extractor.getPluginName();
        if (this.shouldNotAllowRegistration(pluginName)) {
            return Optional.empty();
        }
        for (String warning : extractor.getWarnings()) {
            this.logger.warn("DataExtension API implementation mistake for " + pluginName + ": " + warning);
        }
        ProviderValueGatherer gatherer = new ProviderValueGatherer(extractor, this.dbSystem, this.serverInfo);
        gatherer.storeExtensionInformation();
        this.extensionGatherers.put(pluginName, gatherer);
        this.processing.submitNonCritical(() -> this.updateServerValues(gatherer, CallEvents.SERVER_EXTENSION_REGISTER));
        this.logger.info("Registered extension: " + pluginName);
        return Optional.of(new CallerImplementation(gatherer, this, this.processing));
    }

    @Override
    public void unregister(DataExtension extension) {
        ExtensionWrapper extractor = new ExtensionWrapper(extension);
        String pluginName = extractor.getPluginName();
        if (this.extensionGatherers.remove(pluginName) != null) {
            this.logger.getDebugLogger().logOn("DataExtensions", pluginName + " extension unregistered.");
        }
    }

    private boolean shouldNotAllowRegistration(String pluginName) {
        ExtensionSettings pluginsConfig = this.config.getExtensionSettings();
        if (!pluginsConfig.hasSection(pluginName)) {
            try {
                pluginsConfig.createSection(pluginName);
            }
            catch (IOException e) {
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().whatToDo("Create 'Plugins." + pluginName + ".Enabled: true' setting manually.").related((Object)("Section: " + pluginName)).build());
                this.logger.warn("Could not register DataExtension for " + pluginName + " due to " + e.toString());
                return true;
            }
        }
        if (!pluginsConfig.isEnabled(pluginName)) {
            this.logger.getDebugLogger().logOn("DataExtensions", pluginName + " extension disabled in the config.");
            return true;
        }
        return false;
    }

    public void updatePlayerValues(UUID playerUUID, String playerName, CallEvents event) {
        for (ProviderValueGatherer gatherer : this.extensionGatherers.values()) {
            this.updatePlayerValues(gatherer, playerUUID, playerName, event);
        }
    }

    public void updatePlayerValues(ProviderValueGatherer gatherer, UUID playerUUID, String playerName, CallEvents event) {
        if (gatherer.shouldSkipEvent(event)) {
            return;
        }
        if (playerUUID == null && playerName == null) {
            return;
        }
        try {
            this.logger.getDebugLogger().logOn("DataExtensions", "Gathering values for: " + playerName);
            gatherer.updateValues(playerUUID, playerName);
            this.logger.getDebugLogger().logOn("DataExtensions", "Gathering completed:  " + playerName);
        }
        catch (DataExtensionMethodCallException methodCallFailed) {
            this.logFailure(playerName, methodCallFailed);
            methodCallFailed.getMethod().ifPresent(gatherer::disableMethodFromUse);
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError unexpectedError) {
            ErrorContext.Builder context = ErrorContext.builder().whatToDo("Report and/or disable " + gatherer.getPluginName() + " extension in the Plan config.").related((Object)gatherer.getPluginName()).related((Object)event).related((Object)("Player: " + playerName + " " + playerUUID));
            this.errorLogger.log(L.WARN, unexpectedError, context.build());
        }
    }

    private void logFailure(String playerName, DataExtensionMethodCallException methodCallFailed) {
        Throwable cause = methodCallFailed.getCause();
        ErrorContext.Builder context = ErrorContext.builder().whatToDo("Report and/or disable " + methodCallFailed.getPluginName() + " extension in the Plan config.").related((Object)methodCallFailed.getPluginName()).related((Object)("Method:" + methodCallFailed.getMethod().map(MethodWrapper::getMethodName).orElse("-"))).related((Object)("Player: " + playerName));
        this.errorLogger.log(L.WARN, cause, context.build());
    }

    public void updateServerValues(CallEvents event) {
        for (ProviderValueGatherer gatherer : this.extensionGatherers.values()) {
            this.updateServerValues(gatherer, event);
        }
        UUID serverUUID = this.serverInfo.getServerUUID();
        JSONCache.invalidate(DataID.EXTENSION_NAV, serverUUID);
        JSONCache.invalidate(DataID.EXTENSION_TABS, serverUUID);
    }

    public void updateServerValues(ProviderValueGatherer gatherer, CallEvents event) {
        if (gatherer.shouldSkipEvent(event)) {
            return;
        }
        try {
            this.logger.getDebugLogger().logOn("DataExtensions", "Gathering values for server");
            gatherer.updateValues();
            this.logger.getDebugLogger().logOn("DataExtensions", "Gathering completed for server");
        }
        catch (DataExtensionMethodCallException methodCallFailed) {
            this.logFailure("server", methodCallFailed);
            methodCallFailed.getMethod().ifPresent(gatherer::disableMethodFromUse);
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError unexpectedError) {
            ErrorContext.Builder context = ErrorContext.builder().whatToDo("Report and/or disable " + gatherer.getPluginName() + " extension in the Plan config.").related((Object)gatherer.getPluginName()).related((Object)event).related((Object)"Gathering for server");
            this.errorLogger.log(L.WARN, unexpectedError, context.build());
        }
    }
}

