/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.extractor;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.Group;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.DoubleProvider;
import com.djrapitops.plan.extension.annotation.GroupProvider;
import com.djrapitops.plan.extension.annotation.InvalidateMethod;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PercentageProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TabOrder;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.extractor.MethodAnnotations;
import com.djrapitops.plan.extension.table.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public final class ExtensionExtractor {
    private final DataExtension extension;
    private final String extensionName;
    private final List<String> warnings = new ArrayList<String>();
    private PluginInfo pluginInfo;
    private TabOrder tabOrder;
    private List<TabInfo> tabInformation;
    private List<InvalidateMethod> invalidMethods;
    private MethodAnnotations methodAnnotations;
    private static final String WAS_OVER_50_CHARACTERS = "' was over 50 characters.";

    public ExtensionExtractor(DataExtension extension) {
        this.extension = extension;
        this.extensionName = extension.getClass().getSimpleName();
    }

    public void validateAnnotations() {
        this.extractAnnotationInformation();
        if (!this.warnings.isEmpty()) {
            throw new IllegalArgumentException("Warnings: " + this.warnings.toString());
        }
    }

    private static <V extends DataExtension, T extends Annotation> Optional<T> getClassAnnotation(Class<V> from, Class<T> ofClass) {
        return Optional.ofNullable(from.getAnnotation(ofClass));
    }

    public static <T extends DataExtension> String getPluginName(Class<T> extensionClass) {
        return ExtensionExtractor.getClassAnnotation(extensionClass, PluginInfo.class).map(PluginInfo::name).orElseThrow(() -> new IllegalArgumentException("Given class had no PluginInfo annotation"));
    }

    private Method[] getMethods() {
        return this.extension.getClass().getMethods();
    }

    public void extractAnnotationInformation() {
        this.extractPluginInfo();
        this.extractInvalidMethods();
        this.extractMethodAnnotations();
        this.validateMethodAnnotations();
        this.validateConditionals();
        this.extractTabInfo();
    }

    private void extractMethodAnnotations() {
        this.methodAnnotations = new MethodAnnotations();
        for (Method method : this.getMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) || Modifier.isProtected(modifiers) || Modifier.isStatic(modifiers) || Modifier.isNative(modifiers)) continue;
            MethodAnnotations.get(method, BooleanProvider.class).ifPresent(annotation -> this.methodAnnotations.put(method, BooleanProvider.class, annotation));
            MethodAnnotations.get(method, NumberProvider.class).ifPresent(annotation -> this.methodAnnotations.put(method, NumberProvider.class, annotation));
            MethodAnnotations.get(method, DoubleProvider.class).ifPresent(annotation -> this.methodAnnotations.put(method, DoubleProvider.class, annotation));
            MethodAnnotations.get(method, PercentageProvider.class).ifPresent(annotation -> this.methodAnnotations.put(method, PercentageProvider.class, annotation));
            MethodAnnotations.get(method, StringProvider.class).ifPresent(annotation -> this.methodAnnotations.put(method, StringProvider.class, annotation));
            MethodAnnotations.get(method, Conditional.class).ifPresent(annotation -> this.methodAnnotations.put(method, Conditional.class, annotation));
            MethodAnnotations.get(method, Tab.class).ifPresent(annotation -> this.methodAnnotations.put(method, Tab.class, annotation));
            MethodAnnotations.get(method, TableProvider.class).ifPresent(annotation -> this.methodAnnotations.put(method, TableProvider.class, annotation));
            MethodAnnotations.get(method, GroupProvider.class).ifPresent(annotation -> this.methodAnnotations.put(method, GroupProvider.class, annotation));
        }
        if (this.methodAnnotations.isEmpty()) {
            throw new IllegalArgumentException(this.extensionName + " class had no methods annotated with a Provider annotation");
        }
        try {
            this.methodAnnotations.makeMethodsAccessible();
        }
        catch (SecurityException failedToMakeAccessible) {
            throw new IllegalArgumentException(this.extensionName + " has non accessible Provider method that could not be made accessible: " + failedToMakeAccessible.getMessage(), failedToMakeAccessible);
        }
    }

    private <T> void validateReturnType(Method method, Class<T> expectedType) {
        Class<?> returnType = method.getReturnType();
        if (!expectedType.isAssignableFrom(returnType)) {
            String expectedName = expectedType.getName();
            throw new IllegalArgumentException(this.extensionName + "." + method.getName() + " has invalid return type. was: " + returnType.getName() + ", expected: " + (expectedName.startsWith("[L") ? expectedName + " (an array)" : expectedName));
        }
    }

    private void validateMethodAnnotationPropertyLength(String property, String name, int maxLength, Method method) {
        if (property.length() > maxLength) {
            this.warnings.add(this.extensionName + "." + method.getName() + " '" + name + WAS_OVER_50_CHARACTERS);
        }
    }

    private void validateMethodArguments(Method method, boolean parameterIsRequired, Class ... parameterOptions) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameters = parameterTypes.length;
        if (parameterIsRequired && parameters == 0) {
            throw new IllegalArgumentException(this.extensionName + "." + method.getName() + " requires one of " + Arrays.toString(parameterOptions) + " as a parameter.");
        }
        if (parameters == 0) {
            return;
        }
        if (parameters > 1) {
            throw new IllegalArgumentException(this.extensionName + "." + method.getName() + " has too many parameters, only one of " + Arrays.toString(parameterOptions) + " is required as a parameter.");
        }
        Class<?> methodParameter = parameterTypes[0];
        boolean validParameter = false;
        for (Class option : parameterOptions) {
            if (!option.equals(methodParameter)) continue;
            validParameter = true;
            break;
        }
        if (!validParameter) {
            throw new IllegalArgumentException(this.extensionName + "." + method.getName() + " has invalid parameter: '" + methodParameter.getName() + "' one of " + Arrays.toString(parameterOptions) + " is required as a parameter.");
        }
    }

    private void validateMethodAnnotations() {
        this.validateBooleanProviderAnnotations();
        this.validateNumberProviderAnnotations();
        this.validateDoubleProviderAnnotations();
        this.validatePercentageProviderAnnotations();
        this.validateStringProviderAnnotations();
        this.validateTableProviderAnnotations();
        this.validateGroupProviderAnnotations();
    }

    private void validateBooleanProviderAnnotations() {
        for (Map.Entry<Method, BooleanProvider> booleanProvider : this.methodAnnotations.getMethodAnnotations(BooleanProvider.class).entrySet()) {
            Method method = booleanProvider.getKey();
            BooleanProvider annotation = booleanProvider.getValue();
            this.validateReturnType(method, Boolean.TYPE);
            this.validateMethodAnnotationPropertyLength(annotation.text(), "text", 50, method);
            this.validateMethodAnnotationPropertyLength(annotation.description(), "description", 150, method);
            this.validateMethodAnnotationPropertyLength(annotation.conditionName(), "conditionName", 50, method);
            this.validateMethodArguments(method, false, UUID.class, String.class, Group.class);
            String condition = MethodAnnotations.get(method, Conditional.class).map(Conditional::value).orElse(null);
            if (annotation.conditionName().equals(condition)) {
                this.warnings.add(this.extensionName + "." + method.getName() + " can not be conditional of itself. required condition: " + condition + ", provided condition: " + annotation.conditionName());
            }
            if (!annotation.conditionName().isEmpty() || !annotation.hidden()) continue;
            throw new IllegalArgumentException(this.extensionName + "." + method.getName() + " can not be 'hidden' without a 'conditionName'");
        }
    }

    private void validateNumberProviderAnnotations() {
        for (Map.Entry<Method, NumberProvider> numberProvider : this.methodAnnotations.getMethodAnnotations(NumberProvider.class).entrySet()) {
            Method method = numberProvider.getKey();
            NumberProvider annotation = numberProvider.getValue();
            this.validateReturnType(method, Long.TYPE);
            this.validateMethodAnnotationPropertyLength(annotation.text(), "text", 50, method);
            this.validateMethodAnnotationPropertyLength(annotation.description(), "description", 150, method);
            this.validateMethodArguments(method, false, UUID.class, String.class, Group.class);
        }
    }

    private void validateDoubleProviderAnnotations() {
        for (Map.Entry<Method, DoubleProvider> doubleProvider : this.methodAnnotations.getMethodAnnotations(DoubleProvider.class).entrySet()) {
            Method method = doubleProvider.getKey();
            DoubleProvider annotation = doubleProvider.getValue();
            this.validateReturnType(method, Double.TYPE);
            this.validateMethodAnnotationPropertyLength(annotation.text(), "text", 50, method);
            this.validateMethodAnnotationPropertyLength(annotation.description(), "description", 150, method);
            this.validateMethodArguments(method, false, UUID.class, String.class, Group.class);
        }
    }

    private void validatePercentageProviderAnnotations() {
        for (Map.Entry<Method, PercentageProvider> percentageProvider : this.methodAnnotations.getMethodAnnotations(PercentageProvider.class).entrySet()) {
            Method method = percentageProvider.getKey();
            PercentageProvider annotation = percentageProvider.getValue();
            this.validateReturnType(method, Double.TYPE);
            this.validateMethodAnnotationPropertyLength(annotation.text(), "text", 50, method);
            this.validateMethodAnnotationPropertyLength(annotation.description(), "description", 150, method);
            this.validateMethodArguments(method, false, UUID.class, String.class, Group.class);
        }
    }

    private void validateStringProviderAnnotations() {
        for (Map.Entry<Method, StringProvider> stringProvider : this.methodAnnotations.getMethodAnnotations(StringProvider.class).entrySet()) {
            Method method = stringProvider.getKey();
            StringProvider annotation = stringProvider.getValue();
            this.validateReturnType(method, String.class);
            this.validateMethodAnnotationPropertyLength(annotation.text(), "text", 50, method);
            this.validateMethodAnnotationPropertyLength(annotation.description(), "description", 150, method);
            this.validateMethodArguments(method, false, UUID.class, String.class, Group.class);
        }
    }

    private void validateTableProviderAnnotations() {
        for (Method method : this.methodAnnotations.getMethodAnnotations(TableProvider.class).keySet()) {
            this.validateReturnType(method, Table.class);
            this.validateMethodArguments(method, false, UUID.class, String.class, Group.class);
        }
    }

    private void validateGroupProviderAnnotations() {
        for (Map.Entry<Method, GroupProvider> groupProvider : this.methodAnnotations.getMethodAnnotations(GroupProvider.class).entrySet()) {
            Method method = groupProvider.getKey();
            GroupProvider annotation = groupProvider.getValue();
            this.validateReturnType(method, String[].class);
            this.validateMethodAnnotationPropertyLength(annotation.text(), "text", 50, method);
            this.validateMethodArguments(method, true, UUID.class, String.class);
        }
    }

    private void validateConditionals() {
        Collection<Conditional> conditionals = this.methodAnnotations.getAnnotations(Conditional.class);
        Collection<BooleanProvider> conditionProviders = this.methodAnnotations.getAnnotations(BooleanProvider.class);
        Set providedConditions = conditionProviders.stream().map(BooleanProvider::conditionName).collect(Collectors.toSet());
        for (Conditional condition : conditionals) {
            String conditionName = condition.value();
            if (conditionName.length() > 50) {
                this.warnings.add(this.extensionName + ": '" + conditionName + "' conditionName was over 50 characters.");
            }
            if (providedConditions.contains(conditionName)) continue;
            this.warnings.add(this.extensionName + ": '" + conditionName + "' Condition was not provided by any BooleanProvider.");
        }
        Set<Method> conditionalMethods = this.methodAnnotations.getMethodAnnotations(Conditional.class).keySet();
        for (Method conditionalMethod : conditionalMethods) {
            if (MethodAnnotations.hasAnyOf(conditionalMethod, BooleanProvider.class, DoubleProvider.class, NumberProvider.class, PercentageProvider.class, StringProvider.class, TableProvider.class, GroupProvider.class)) continue;
            throw new IllegalArgumentException(this.extensionName + "." + conditionalMethod.getName() + " did not have any associated Provider for Conditional.");
        }
    }

    private <T extends Annotation> Optional<T> getClassAnnotation(Class<T> ofClass) {
        return ExtensionExtractor.getClassAnnotation(this.extension.getClass(), ofClass);
    }

    private void extractPluginInfo() {
        this.pluginInfo = this.getClassAnnotation(PluginInfo.class).orElseThrow(() -> new IllegalArgumentException("Given class had no PluginInfo annotation"));
        if (this.pluginInfo.name().length() > 50) {
            this.warnings.add(this.extensionName + " PluginInfo 'name' was over 50 characters.");
        }
    }

    private void extractTabInfo() {
        String tabName;
        this.tabInformation = new ArrayList<TabInfo>();
        this.getClassAnnotation(TabInfo.Multiple.class).ifPresent(tabs -> {
            for (TabInfo tabInfo : tabs.value()) {
                String tabName = tabInfo.tab();
                if (tabName.length() > 50) {
                    this.warnings.add(this.extensionName + " tabName '" + tabName + WAS_OVER_50_CHARACTERS);
                }
                this.tabInformation.add(tabInfo);
            }
        });
        this.tabOrder = this.getClassAnnotation(TabOrder.class).orElse(null);
        Map<Method, Tab> tabs2 = this.methodAnnotations.getMethodAnnotations(Tab.class);
        Set tabNames = tabs2.values().stream().map(Tab::value).collect(Collectors.toSet());
        for (TabInfo tabInfo : this.tabInformation) {
            tabName = tabInfo.tab();
            if (tabName.length() > 50) {
                this.warnings.add(this.extensionName + " TabInfo " + tabName + " name was over 50 characters.");
            }
            if (tabNames.contains(tabName)) continue;
            this.warnings.add(this.extensionName + " has TabInfo for " + tabName + ", but it is not used.");
        }
        for (Map.Entry entry : tabs2.entrySet()) {
            tabName = ((Tab)entry.getValue()).value();
            if (tabName.length() <= 50) continue;
            this.warnings.add(this.extensionName + "." + ((Method)entry.getKey()).getName() + " Tab '" + tabName + "' name was over 50 characters.");
        }
    }

    private void extractInvalidMethods() {
        this.invalidMethods = new ArrayList<InvalidateMethod>();
        this.getClassAnnotation(InvalidateMethod.Multiple.class).ifPresent(tabs -> {
            for (InvalidateMethod tabInfo : tabs.value()) {
                String methodName = tabInfo.value();
                if (methodName.length() > 50) {
                    this.warnings.add(this.extensionName + " invalidated method '" + methodName + WAS_OVER_50_CHARACTERS);
                }
                this.invalidMethods.add(tabInfo);
            }
        });
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    public Optional<TabOrder> getTabOrder() {
        return Optional.ofNullable(this.tabOrder);
    }

    public List<TabInfo> getTabInformation() {
        return this.tabInformation != null ? this.tabInformation : Collections.emptyList();
    }

    public MethodAnnotations getMethodAnnotations() {
        return this.methodAnnotations;
    }

    public List<InvalidateMethod> getInvalidateMethodAnnotations() {
        return this.invalidMethods != null ? this.invalidMethods : Collections.emptyList();
    }
}

