/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.extractor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MethodAnnotations {
    private final Map<Class<?>, Map<Method, Annotation>> byAnnotationType = new HashMap();

    public static boolean hasAnyOf(Method method, Class<?> ... annotationClasses) {
        for (Annotation annotation : method.getAnnotations()) {
            for (Class<?> annotationClass : annotationClasses) {
                if (!annotationClass.isAssignableFrom(annotation.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public static <T extends Annotation> Optional<T> get(Method from, Class<T> ofClass) {
        return Optional.ofNullable(from.getAnnotation(ofClass));
    }

    public <T extends Annotation> void put(Method method, Class<T> annotationClass, T annotation) {
        Map methods = this.byAnnotationType.getOrDefault(annotationClass, new HashMap());
        methods.put(method, annotation);
        this.byAnnotationType.put(annotationClass, methods);
    }

    public <T extends Annotation> Map<Method, T> getMethodAnnotations(Class<T> ofType) {
        return this.byAnnotationType.getOrDefault(ofType, new HashMap());
    }

    public <T extends Annotation> Collection<T> getAnnotations(Class<T> ofType) {
        return this.getMethodAnnotations(ofType).values();
    }

    public boolean isEmpty() {
        return this.byAnnotationType.isEmpty();
    }

    public String toString() {
        return "MethodAnnotations{" + this.byAnnotationType + '}';
    }

    void makeMethodsAccessible() {
        this.byAnnotationType.values().stream().map(Map::keySet).flatMap(Collection::stream).distinct().filter(method -> !method.isAccessible()).forEach(method -> method.setAccessible(true));
    }
}

