/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.icon;

import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;

public class Icon {
    private Family type;
    private String name;
    private Color color;

    private Icon() {
        this.type = Family.SOLID;
        this.color = Color.NONE;
    }

    public Icon(Family type, String name, Color color) {
        this.type = type;
        this.name = name;
        this.color = color;
    }

    public static Builder called(String name) {
        return new Builder().called(name);
    }

    public static Builder of(Family type) {
        return new Builder().of(type);
    }

    public static Builder of(Color color) {
        return new Builder().of(color);
    }

    public Family getFamily() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public Icon setColor(Color color) {
        this.color = color;
        return this;
    }

    public String toString() {
        return "Icon{" + this.type.name() + ", '" + this.name + '\'' + ", " + this.color.name() + '}';
    }

    public static class Builder {
        private final Icon icon = new Icon();

        Builder() {
        }

        public Builder called(String name) {
            this.icon.name = name;
            return this;
        }

        public Builder of(Color color) {
            this.icon.color = color;
            return this;
        }

        public Builder of(Family type) {
            this.icon.type = type;
            return this;
        }

        public Icon build() {
            if (this.icon.name == null) {
                throw new IllegalStateException("'name' was not defined yet!");
            }
            return this.icon;
        }
    }
}

