/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.Caller;
import com.djrapitops.plan.extension.ExtensionSvc;
import com.djrapitops.plan.extension.implementation.providers.gathering.ProviderValueGatherer;
import com.djrapitops.plan.processing.Processing;
import java.util.UUID;

public class CallerImplementation
implements Caller {
    private final ProviderValueGatherer gatherer;
    private final ExtensionSvc extensionService;
    private final Processing processing;

    public CallerImplementation(ProviderValueGatherer gatherer, ExtensionSvc extensionService, Processing processing) {
        this.gatherer = gatherer;
        this.extensionService = extensionService;
        this.processing = processing;
    }

    @Override
    public void updatePlayerData(UUID playerUUID, String playerName) {
        this.processing.submitNonCritical(() -> this.extensionService.updatePlayerValues(this.gatherer, playerUUID, playerName, CallEvents.MANUAL));
    }

    @Override
    public void updateServerData() {
        this.processing.submitNonCritical(() -> this.extensionService.updateServerValues(this.gatherer, CallEvents.MANUAL));
    }
}

