/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation;

import com.djrapitops.extension.AACExtensionFactory;
import com.djrapitops.extension.ASkyBlockExtensionFactory;
import com.djrapitops.extension.AdvancedAchievementsExtensionFactory;
import com.djrapitops.extension.AdvancedBanExtensionFactory;
import com.djrapitops.extension.BanManagerExtensionFactory;
import com.djrapitops.extension.BentoBoxExtensionFactory;
import com.djrapitops.extension.BuycraftExtensionFactory;
import com.djrapitops.extension.DKBansExtensionFactory;
import com.djrapitops.extension.DKCoinsExtensionFactory;
import com.djrapitops.extension.DiscordSRVExtensionFactory;
import com.djrapitops.extension.EssentialsExtensionFactory;
import com.djrapitops.extension.FactionsExtensionFactory;
import com.djrapitops.extension.GriefDefenderExtensionFactory;
import com.djrapitops.extension.GriefPreventionExtensionFactory;
import com.djrapitops.extension.GriefPreventionPlusExtensionFactory;
import com.djrapitops.extension.GriefPreventionSpongeExtensionFactory;
import com.djrapitops.extension.JobsExtensionFactory;
import com.djrapitops.extension.LitebansExtensionFactory;
import com.djrapitops.extension.LuckPermsExtensionFactory;
import com.djrapitops.extension.McMMOExtensionFactory;
import com.djrapitops.extension.MinigameLibExtensionFactory;
import com.djrapitops.extension.NuVotifierExtensionFactory;
import com.djrapitops.extension.NucleusExtensionFactory;
import com.djrapitops.extension.ProtocolSupportExtensionFactory;
import com.djrapitops.extension.RedProtectExtensionFactory;
import com.djrapitops.extension.SpongeEconomyExtensionFactory;
import com.djrapitops.extension.SuperbVoteExtensionFactory;
import com.djrapitops.extension.TownyExtensionFactory;
import com.djrapitops.extension.VaultExtensionFactory;
import com.djrapitops.extension.ViaVersionExtensionFactory;
import com.djrapitops.plan.extension.Caller;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.ExtensionService;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.extractor.ExtensionExtractor;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import plan.javax.inject.Inject;
import plan.javax.inject.Named;
import plan.javax.inject.Singleton;

@Singleton
public class ExtensionRegister {
    private final Predicate<String> isExtensionEnabledInConfig;
    private IllegalStateException registerException;
    private Set<String> disabledExtensions;
    private ExtensionService extensionService;

    @Inject
    public ExtensionRegister(@Named(value="isExtensionEnabled") Predicate<String> isExtensionEnabledInConfig) {
        this.isExtensionEnabledInConfig = isExtensionEnabledInConfig;
    }

    public void registerBuiltInExtensions(Set<String> disabledExtensions) {
        this.disabledExtensions = disabledExtensions;
        this.extensionService = ExtensionService.getInstance();
        this.register(new AACExtensionFactory(), AACExtensionFactory::createExtension);
        this.register(new AdvancedAchievementsExtensionFactory(), AdvancedAchievementsExtensionFactory::createExtension);
        this.register(new AdvancedBanExtensionFactory(), AdvancedBanExtensionFactory::createExtension, AdvancedBanExtensionFactory::registerListener);
        this.register(new ASkyBlockExtensionFactory(), ASkyBlockExtensionFactory::createExtension);
        this.register(new BanManagerExtensionFactory(), BanManagerExtensionFactory::createExtension);
        this.registerBentoBoxExtensions();
        this.register(new BuycraftExtensionFactory(), BuycraftExtensionFactory::createExtension);
        this.register(new DiscordSRVExtensionFactory(), DiscordSRVExtensionFactory::createExtension, DiscordSRVExtensionFactory::registerListener);
        this.register(new DKBansExtensionFactory(), DKBansExtensionFactory::createExtension, DKBansExtensionFactory::registerListener);
        this.register(new DKCoinsExtensionFactory(), DKCoinsExtensionFactory::createExtension, DKCoinsExtensionFactory::registerListener);
        this.register(new EssentialsExtensionFactory(), EssentialsExtensionFactory::createExtension, EssentialsExtensionFactory::registerUpdateListeners);
        this.register(new FactionsExtensionFactory(), FactionsExtensionFactory::createExtension);
        this.register(new GriefDefenderExtensionFactory(), GriefDefenderExtensionFactory::createExtension);
        this.register(new GriefPreventionExtensionFactory(), GriefPreventionExtensionFactory::createExtension);
        this.register(new GriefPreventionSpongeExtensionFactory(), GriefPreventionSpongeExtensionFactory::createExtension);
        this.register(new GriefPreventionPlusExtensionFactory(), GriefPreventionPlusExtensionFactory::createExtension);
        this.register(new JobsExtensionFactory(), JobsExtensionFactory::createExtension);
        this.register(new LitebansExtensionFactory(), LitebansExtensionFactory::createExtension, LitebansExtensionFactory::registerEvents);
        this.register(new LuckPermsExtensionFactory(), LuckPermsExtensionFactory::createExtension);
        this.register(new McMMOExtensionFactory(), McMMOExtensionFactory::createExtension);
        this.registerMany(new MinigameLibExtensionFactory(), MinigameLibExtensionFactory::createExtensions);
        this.register(new NucleusExtensionFactory(), NucleusExtensionFactory::createExtension);
        this.register(new NuVotifierExtensionFactory(), NuVotifierExtensionFactory::createExtension);
        this.register(new ProtocolSupportExtensionFactory(), ProtocolSupportExtensionFactory::createExtension);
        this.register(new RedProtectExtensionFactory(), RedProtectExtensionFactory::createExtension);
        this.register(new SpongeEconomyExtensionFactory(), SpongeEconomyExtensionFactory::createExtension);
        this.register(new SuperbVoteExtensionFactory(), SuperbVoteExtensionFactory::createExtension);
        this.register(new TownyExtensionFactory(), TownyExtensionFactory::createExtension);
        this.registerMany(new VaultExtensionFactory(), VaultExtensionFactory::createExtensions);
        this.register(new ViaVersionExtensionFactory(), ViaVersionExtensionFactory::createExtension, ViaVersionExtensionFactory::registerListener);
        if (this.registerException != null) {
            throw this.registerException;
        }
    }

    private void registerBentoBoxExtensions() {
        BentoBoxExtensionFactory factory = new BentoBoxExtensionFactory();
        if (factory.isAvailable()) {
            for (DataExtension minigame : factory.createExtensions()) {
                this.register(minigame);
            }
        }
    }

    private void suppressException(Class<?> factory, Throwable e) {
        String factoryName = factory.getSimpleName();
        String extensionName = factoryName.replace("ExtensionFactory", "");
        if (!this.isExtensionEnabledInConfig.test(extensionName)) {
            return;
        }
        if (this.registerException == null) {
            this.registerException = new IllegalStateException("One or more extensions failed to register:");
            this.registerException.setStackTrace(new StackTraceElement[0]);
        }
        IllegalStateException info = new IllegalStateException(factoryName + " failed to create Extension", e);
        this.removeUselessStackTraces(info);
        this.registerException.addSuppressed(info);
    }

    private void removeUselessStackTraces(Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof ReflectiveOperationException || t instanceof NoClassDefFoundError || t instanceof NoSuchFieldError || t instanceof NoSuchMethodError || t instanceof IllegalStateException) {
            t.setStackTrace(new StackTraceElement[0]);
        }
        this.removeUselessStackTraces(t.getCause());
    }

    private <T> void register(T factory, Function<T, Optional<DataExtension>> createExtension) {
        try {
            createExtension.apply(factory).ifPresent(this::register);
        }
        catch (NotReadyException notReadyException) {
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError e) {
            this.suppressException(factory.getClass(), e);
        }
    }

    private <T> void registerMany(T factory, Function<T, Collection<DataExtension>> createExtension) {
        try {
            createExtension.apply(factory).forEach(this::register);
        }
        catch (NotReadyException notReadyException) {
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError e) {
            this.suppressException(factory.getClass(), e);
        }
    }

    private <T> void register(T factory, Function<T, Optional<DataExtension>> createExtension, BiConsumer<T, Caller> registerListener) {
        try {
            createExtension.apply(factory).flatMap(this::register).ifPresent(caller -> registerListener.accept(factory, (Caller)caller));
        }
        catch (NotReadyException notReadyException) {
        }
        catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError e) {
            this.suppressException(factory.getClass(), e);
        }
    }

    private Optional<Caller> register(DataExtension dataExtension) {
        String extensionName = ExtensionExtractor.getPluginName(dataExtension.getClass());
        if (this.disabledExtensions.contains(extensionName)) {
            return Optional.empty();
        }
        return this.extensionService.register(dataExtension);
    }
}

