/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.annotation.BooleanProvider;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.annotation.DoubleProvider;
import com.djrapitops.plan.extension.annotation.GroupProvider;
import com.djrapitops.plan.extension.annotation.InvalidateMethod;
import com.djrapitops.plan.extension.annotation.NumberProvider;
import com.djrapitops.plan.extension.annotation.PercentageProvider;
import com.djrapitops.plan.extension.annotation.PluginInfo;
import com.djrapitops.plan.extension.annotation.StringProvider;
import com.djrapitops.plan.extension.annotation.Tab;
import com.djrapitops.plan.extension.annotation.TabInfo;
import com.djrapitops.plan.extension.annotation.TabOrder;
import com.djrapitops.plan.extension.annotation.TableProvider;
import com.djrapitops.plan.extension.extractor.ExtensionExtractor;
import com.djrapitops.plan.extension.extractor.MethodAnnotations;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.providers.BooleanDataProvider;
import com.djrapitops.plan.extension.implementation.providers.DataProviders;
import com.djrapitops.plan.extension.implementation.providers.DoubleDataProvider;
import com.djrapitops.plan.extension.implementation.providers.GroupDataProvider;
import com.djrapitops.plan.extension.implementation.providers.NumberDataProvider;
import com.djrapitops.plan.extension.implementation.providers.PercentageDataProvider;
import com.djrapitops.plan.extension.implementation.providers.StringDataProvider;
import com.djrapitops.plan.extension.implementation.providers.TableDataProvider;
import com.djrapitops.plan.utilities.java.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExtensionWrapper {
    private final ExtensionExtractor extractor;
    private final DataProviders providers;
    private final DataExtension extension;

    public ExtensionWrapper(DataExtension extension) {
        this.extension = extension;
        this.extractor = new ExtensionExtractor(this.extension);
        this.extractor.extractAnnotationInformation();
        this.providers = new DataProviders();
        this.extractProviders();
    }

    public CallEvents[] getCallEvents() {
        return this.extension.callExtensionMethodsOn();
    }

    public DataExtension getExtension() {
        return this.extension;
    }

    public String getPluginName() {
        return this.extractor.getPluginInfo().name();
    }

    public Icon getPluginIcon() {
        PluginInfo pluginInfo = this.extractor.getPluginInfo();
        return new Icon(pluginInfo.iconFamily(), pluginInfo.iconName(), pluginInfo.color());
    }

    public Collection<TabInformation> getPluginTabs() {
        Map tabInformation = this.extractor.getTabInformation().stream().collect(Collectors.toMap(TabInfo::tab, Function.identity(), (one, two) -> one));
        Map order = this.getTabOrder().map(this::orderToMap).orElse(new HashMap());
        return this.extractor.getMethodAnnotations().getAnnotations(Tab.class).stream().map(Tab::value).distinct().map(tabName -> {
            Optional tabInfo = Optional.ofNullable(tabInformation.get(tabName));
            return new TabInformation((String)tabName, tabInfo.map(info -> new Icon(info.iconFamily(), info.iconName(), Color.NONE)).orElse(null), tabInfo.map(TabInfo::elementOrder).orElse(null), order.getOrDefault(tabName, 100));
        }).collect(Collectors.toList());
    }

    private Map<String, Integer> orderToMap(String[] order) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < order.length; ++i) {
            map.put(order[i], i);
        }
        return map;
    }

    public Optional<String[]> getTabOrder() {
        return this.extractor.getTabOrder().map(TabOrder::value);
    }

    public Collection<String> getInvalidatedMethods() {
        return Lists.mapUnique(this.extractor.getInvalidateMethodAnnotations(), InvalidateMethod::value);
    }

    public DataProviders getProviders() {
        return this.providers;
    }

    private void extractProviders() {
        PluginInfo pluginInfo = this.extractor.getPluginInfo();
        MethodAnnotations methodAnnotations = this.extractor.getMethodAnnotations();
        Map<Method, Tab> tabs = methodAnnotations.getMethodAnnotations(Tab.class);
        Map<Method, Conditional> conditions = methodAnnotations.getMethodAnnotations(Conditional.class);
        this.extractProviders(pluginInfo, tabs, conditions, BooleanProvider.class, BooleanDataProvider::placeToDataProviders);
        this.extractProviders(pluginInfo, tabs, conditions, DoubleProvider.class, DoubleDataProvider::placeToDataProviders);
        this.extractProviders(pluginInfo, tabs, conditions, PercentageProvider.class, PercentageDataProvider::placeToDataProviders);
        this.extractProviders(pluginInfo, tabs, conditions, NumberProvider.class, NumberDataProvider::placeToDataProviders);
        this.extractProviders(pluginInfo, tabs, conditions, StringProvider.class, StringDataProvider::placeToDataProviders);
        this.extractProviders(pluginInfo, tabs, conditions, TableProvider.class, TableDataProvider::placeToDataProviders);
        this.extractProviders(pluginInfo, tabs, conditions, GroupProvider.class, GroupDataProvider::placeToDataProviders);
    }

    private <T extends Annotation> void extractProviders(PluginInfo pluginInfo, Map<Method, Tab> tabs, Map<Method, Conditional> conditions, Class<T> ofKind, DataProviderFactory<T> factory) {
        String pluginName = pluginInfo.name();
        for (Map.Entry<Method, T> entry : this.extractor.getMethodAnnotations().getMethodAnnotations(ofKind).entrySet()) {
            Method method = entry.getKey();
            Annotation annotation = (Annotation)entry.getValue();
            Conditional conditional = conditions.get(method);
            Optional<Tab> tab = Optional.ofNullable(tabs.get(method));
            factory.placeToDataProviders(this.providers, method, annotation, conditional, tab.map(Tab::value).orElse(null), pluginName);
        }
    }

    public Collection<String> getWarnings() {
        return this.extractor.getWarnings();
    }

    static interface DataProviderFactory<T extends Annotation> {
        public void placeToDataProviders(DataProviders var1, Method var2, T var3, Conditional var4, String var5, String var6);
    }
}

