/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation;

import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.annotation.Conditional;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import java.util.Objects;
import java.util.Optional;
import plan.org.apache.commons.lang3.StringUtils;

public class ProviderInformation
extends ExtensionDescriptive {
    private final String pluginName;
    private final boolean showInPlayersTable;
    private final String tab;
    private final Conditional condition;
    private final boolean hidden;
    private final String providedCondition;
    private final FormatType formatType;
    private final boolean isPlayerName;
    private final Color tableColor;
    private final boolean percentage;

    private ProviderInformation(Builder builder) {
        super(builder.name, builder.text, builder.description, builder.icon, builder.priority);
        this.pluginName = builder.pluginName;
        this.showInPlayersTable = builder.showInPlayersTable;
        this.tab = builder.tab;
        this.condition = builder.condition;
        this.hidden = builder.hidden;
        this.providedCondition = builder.providedCondition;
        this.formatType = builder.formatType;
        this.isPlayerName = builder.isPlayerName;
        this.tableColor = builder.tableColor;
        this.percentage = builder.percentage;
    }

    public static Builder builder(String pluginName) {
        return new Builder(pluginName);
    }

    public String getPluginName() {
        return StringUtils.truncate(this.pluginName, 50);
    }

    public boolean isShownInPlayersTable() {
        return this.showInPlayersTable;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getProvidedCondition() {
        return this.providedCondition;
    }

    public Optional<FormatType> getFormatType() {
        return Optional.ofNullable(this.formatType);
    }

    public boolean isPlayerName() {
        return this.isPlayerName;
    }

    public Optional<String> getTab() {
        return this.tab == null || this.tab.isEmpty() ? Optional.empty() : Optional.of(StringUtils.truncate(this.tab, 50));
    }

    public Optional<String> getCondition() {
        if (this.condition == null || this.condition.value().isEmpty()) {
            return Optional.empty();
        }
        if (this.condition.negated()) {
            return Optional.of("not_" + this.getTruncatedConditionName());
        }
        return Optional.of(this.getTruncatedConditionName());
    }

    private String getTruncatedConditionName() {
        return StringUtils.truncate(this.condition.value(), 50);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProviderInformation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProviderInformation that = (ProviderInformation)o;
        return this.pluginName.equals(that.pluginName) && Objects.equals(this.tab, that.tab) && Objects.equals(this.condition, that.condition);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pluginName, this.tab, this.condition);
    }

    public Color getTableColor() {
        return this.tableColor;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public static class Builder {
        private final String pluginName;
        private String name;
        private String text;
        private String description;
        private Icon icon;
        private int priority;
        private boolean showInPlayersTable = false;
        private String tab;
        private Conditional condition;
        private boolean hidden = false;
        private String providedCondition;
        private FormatType formatType;
        private boolean isPlayerName = false;
        private Color tableColor;
        private boolean percentage;

        public Builder(String pluginName) {
            this.pluginName = pluginName;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setText(String text) {
            this.text = text;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setIcon(Icon icon) {
            this.icon = icon;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setShowInPlayersTable(boolean showInPlayersTable) {
            this.showInPlayersTable = showInPlayersTable;
            return this;
        }

        public Builder setTab(String tab) {
            this.tab = tab;
            return this;
        }

        public Builder setCondition(Conditional condition) {
            this.condition = condition;
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setProvidedCondition(String providedCondition) {
            this.providedCondition = providedCondition;
            return this;
        }

        public Builder setFormatType(FormatType formatType) {
            this.formatType = formatType;
            return this;
        }

        public Builder setPlayerName(boolean playerName) {
            this.isPlayerName = playerName;
            return this;
        }

        public Builder setTableColor(Color tableColor) {
            this.tableColor = tableColor;
            return this;
        }

        public Builder setAsPercentage() {
            this.percentage = true;
            return this;
        }

        public ProviderInformation build() {
            return new ProviderInformation(this);
        }
    }
}

