/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plugin.utilities.ArrayUtil;
import java.util.Arrays;
import java.util.Optional;
import plan.org.apache.commons.lang3.StringUtils;

public class TabInformation {
    private final String tabName;
    private final Icon icon;
    private ElementOrder[] elementOrder;
    private final int tabPriority;

    public TabInformation(String tabName, Icon icon, ElementOrder[] elementOrder, int tabPriority) {
        this.tabName = tabName;
        this.icon = icon;
        this.elementOrder = elementOrder;
        this.tabPriority = tabPriority;
    }

    public String getTabName() {
        return StringUtils.truncate(this.tabName, 50);
    }

    public static Icon defaultIcon() {
        return new Icon(Family.SOLID, "circle", Color.NONE);
    }

    public Icon getTabIcon() {
        return this.icon != null ? this.icon : TabInformation.defaultIcon();
    }

    public int getTabPriority() {
        return this.tabPriority;
    }

    public Optional<ElementOrder[]> getTabElementOrder() {
        if (this.elementOrder == null) {
            return Optional.empty();
        }
        ElementOrder[] possibleValues = ElementOrder.values();
        if (this.elementOrder.length < possibleValues.length) {
            this.addMissingElements(possibleValues);
        }
        return Optional.of(this.elementOrder);
    }

    private void addMissingElements(ElementOrder[] possibleValues) {
        for (ElementOrder possibleValue : possibleValues) {
            if (Arrays.binarySearch((Object[])this.elementOrder, (Object)possibleValue) >= 0) continue;
            this.elementOrder = ArrayUtil.merge(this.elementOrder, {possibleValue});
        }
    }

    public String toString() {
        return "TabInformation{tabName='" + this.tabName + '\'' + ", icon=" + this.icon + ", elementOrder=" + Arrays.toString((Object[])this.elementOrder) + ", tabPriority=" + this.tabPriority + '}';
    }
}

