/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.providers;

import com.djrapitops.plan.extension.implementation.MethodType;
import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.extension.implementation.providers.MethodWrapper;
import com.djrapitops.plan.utilities.java.Lists;
import com.djrapitops.plan.utilities.java.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class DataProviders {
    private final Map<MethodType, Map<Class<?>, List<DataProvider<?>>>> byMethodType = new EnumMap(MethodType.class);

    public void put(DataProvider<?> provider) {
        MethodWrapper<?> method = provider.getMethod();
        MethodType methodType = method.getMethodType();
        Class<?> returnType = method.getReturnType();
        this.computeIfAbsent(methodType, returnType).add(provider);
    }

    private List<DataProvider<?>> computeIfAbsent(MethodType methodType, Class<?> returnType) {
        return this.byMethodType.computeIfAbsent(methodType, Maps::create).computeIfAbsent(returnType, Lists::create);
    }

    public <T> List<DataProvider<T>> getProvidersByTypes(MethodType methodType, Class<T> returnType) {
        Map byReturnType = this.byMethodType.getOrDefault((Object)methodType, Collections.emptyMap());
        List uncastProviders = (List)byReturnType.get(returnType);
        if (uncastProviders == null) {
            return Collections.emptyList();
        }
        ArrayList<DataProvider<T>> providers = new ArrayList<DataProvider<T>>();
        for (DataProvider dataProvider : uncastProviders) {
            providers.add(dataProvider);
        }
        return providers;
    }

    public <T> List<DataProvider<T>> getPlayerMethodsByType(Class<T> returnType) {
        return this.getProvidersByTypes(MethodType.PLAYER, returnType);
    }

    public <T> List<DataProvider<T>> getServerMethodsByType(Class<T> returnType) {
        return this.getProvidersByTypes(MethodType.SERVER, returnType);
    }

    public <T> List<DataProvider<T>> getGroupMethodsByType(Class<T> returnType) {
        return this.getProvidersByTypes(MethodType.GROUP, returnType);
    }

    public <T> void removeProviderWithMethod(MethodWrapper<T> toRemove) {
        MethodType methodType = toRemove.getMethodType();
        Map byResultType = this.byMethodType.getOrDefault((Object)methodType, Collections.emptyMap());
        if (byResultType.isEmpty()) {
            return;
        }
        Class<T> returnType = toRemove.getReturnType();
        List<DataProvider<T>> providers = this.getProvidersByTypes(methodType, returnType);
        DataProvider<T> providerToRemove = null;
        for (DataProvider<T> provider : providers) {
            if (!provider.getMethod().equals(toRemove)) continue;
            providerToRemove = provider;
            break;
        }
        providers.remove(providerToRemove);
    }
}

