/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.providers;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.NotReadyException;
import com.djrapitops.plan.extension.implementation.MethodType;
import com.djrapitops.plan.extension.implementation.providers.Parameters;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

public class MethodWrapper<T> {
    private final Method method;
    private final Class<T> returnType;
    private final MethodType methodType;
    private boolean disabled = false;

    public MethodWrapper(Method method, Class<T> returnType) {
        this.method = method;
        this.returnType = returnType;
        this.methodType = MethodType.forMethod(this.method);
    }

    public T callMethod(DataExtension extension, Parameters with) {
        if (this.disabled) {
            return null;
        }
        try {
            return this.returnType.cast(with.usingOn(extension, this.method));
        }
        catch (InvocationTargetException notReadyToBeCalled) {
            if (notReadyToBeCalled.getCause() instanceof NotReadyException) {
                return null;
            }
            throw new IllegalArgumentException(this.method.getDeclaringClass() + " method " + this.method.getName() + " could not be called: " + notReadyToBeCalled.getMessage(), notReadyToBeCalled);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(this.method.getDeclaringClass() + " method " + this.method.getName() + " could not be called: " + e.getMessage(), e);
        }
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public void disable() {
        this.disabled = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodWrapper)) {
            return false;
        }
        MethodWrapper that = (MethodWrapper)o;
        return this.method.equals(that.method) && this.returnType.equals(that.returnType) && this.methodType == that.methodType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.returnType, this.methodType});
    }
}

