/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.providers;

import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.Group;
import com.djrapitops.plan.extension.implementation.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;

public interface Parameters {
    public static Parameters player(UUID serverUUID, UUID playerUUID, String playerName) {
        return new PlayerParameters(serverUUID, playerUUID, playerName);
    }

    public static Parameters server(UUID serverUUID) {
        return new ServerParameters(serverUUID);
    }

    public static Parameters group(UUID serverUUID, String groupName) {
        return new GroupParameters(serverUUID, groupName);
    }

    public Object usingOn(DataExtension var1, Method var2) throws InvocationTargetException, IllegalAccessException;

    public MethodType getMethodType();

    public UUID getServerUUID();

    default public UUID getPlayerUUID() {
        return null;
    }

    public static class GroupParameters
    implements Parameters {
        private final UUID serverUUID;
        private final String groupName;

        private GroupParameters(UUID serverUUID, String groupName) {
            this.serverUUID = serverUUID;
            this.groupName = groupName;
        }

        @Override
        public UUID getServerUUID() {
            return this.serverUUID;
        }

        @Override
        public Object usingOn(DataExtension extension, Method method) throws InvocationTargetException, IllegalAccessException {
            Group group = this::getGroupName;
            return method.invoke((Object)extension, group);
        }

        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public MethodType getMethodType() {
            return MethodType.GROUP;
        }
    }

    public static class PlayerParameters
    implements Parameters {
        private final UUID serverUUID;
        private final UUID playerUUID;
        private final String playerName;

        private PlayerParameters(UUID serverUUID, UUID playerUUID, String playerName) {
            this.serverUUID = serverUUID;
            this.playerUUID = playerUUID;
            this.playerName = playerName;
        }

        @Override
        public UUID getServerUUID() {
            return this.serverUUID;
        }

        @Override
        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        @Override
        public Object usingOn(DataExtension extension, Method method) throws InvocationTargetException, IllegalAccessException {
            Class<?> parameterType = method.getParameterTypes()[0];
            if (UUID.class.equals(parameterType)) {
                return method.invoke((Object)extension, this.playerUUID);
            }
            return method.invoke((Object)extension, this.playerName);
        }

        @Override
        public MethodType getMethodType() {
            return MethodType.PLAYER;
        }
    }

    public static class ServerParameters
    implements Parameters {
        private final UUID serverUUID;

        private ServerParameters(UUID serverUUID) {
            this.serverUUID = serverUUID;
        }

        @Override
        public UUID getServerUUID() {
            return this.serverUUID;
        }

        @Override
        public Object usingOn(DataExtension extension, Method method) throws InvocationTargetException, IllegalAccessException {
            return method.invoke((Object)extension, new Object[0]);
        }

        @Override
        public MethodType getMethodType() {
            return MethodType.SERVER;
        }
    }
}

