/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.providers.gathering;

import com.djrapitops.plan.exceptions.DataExtensionMethodCallException;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.implementation.ExtensionWrapper;
import com.djrapitops.plan.extension.implementation.ProviderInformation;
import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.extension.implementation.providers.DataProviders;
import com.djrapitops.plan.extension.implementation.providers.MethodWrapper;
import com.djrapitops.plan.extension.implementation.providers.Parameters;
import com.djrapitops.plan.extension.implementation.providers.gathering.Conditions;
import com.djrapitops.plan.extension.implementation.storage.transactions.StoreIconTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.providers.StoreProviderTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StorePlayerBooleanResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StoreServerBooleanResultTransaction;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;

class BooleanProviderValueGatherer {
    private final String pluginName;
    private final DataExtension extension;
    private final UUID serverUUID;
    private final Database database;
    private final DataProviders dataProviders;

    BooleanProviderValueGatherer(String pluginName, UUID serverUUID, Database database, ExtensionWrapper extensionWrapper) {
        this.pluginName = pluginName;
        this.extension = extensionWrapper.getExtension();
        this.serverUUID = serverUUID;
        this.database = database;
        this.dataProviders = extensionWrapper.getProviders();
    }

    Conditions gatherBooleanDataOfPlayer(UUID playerUUID, String playerName) {
        Set<DataProvider<Boolean>> satisfied;
        Conditions conditions = new Conditions();
        ArrayList<DataProvider<Boolean>> unsatisfiedProviders = new ArrayList<DataProvider<Boolean>>(this.dataProviders.getPlayerMethodsByType(Boolean.class));
        Function<MethodWrapper<Boolean>, Callable<Boolean>> methodCaller = method -> () -> (Boolean)method.callMethod(this.extension, Parameters.player(this.serverUUID, playerUUID, playerName));
        BiFunction<MethodWrapper<Boolean>, Boolean, Transaction> storeTrancationCreator = (method, result) -> new StorePlayerBooleanResultTransaction(this.pluginName, this.serverUUID, method.getMethodName(), playerUUID, (boolean)result);
        do {
            satisfied = this.attemptToSatisfyMoreConditionsAndStoreResults(methodCaller, storeTrancationCreator, conditions, unsatisfiedProviders);
            unsatisfiedProviders.removeAll(satisfied);
        } while (!satisfied.isEmpty());
        return conditions;
    }

    Conditions gatherBooleanDataOfServer() {
        Set<DataProvider<Boolean>> satisfied;
        Conditions conditions = new Conditions();
        ArrayList<DataProvider<Boolean>> unsatisfiedProviders = new ArrayList<DataProvider<Boolean>>(this.dataProviders.getServerMethodsByType(Boolean.class));
        Function<MethodWrapper<Boolean>, Callable<Boolean>> methodCaller = method -> () -> (Boolean)method.callMethod(this.extension, Parameters.server(this.serverUUID));
        BiFunction<MethodWrapper<Boolean>, Boolean, Transaction> storeTransactionCreator = (method, result) -> new StoreServerBooleanResultTransaction(this.pluginName, this.serverUUID, method.getMethodName(), (boolean)result);
        do {
            satisfied = this.attemptToSatisfyMoreConditionsAndStoreResults(methodCaller, storeTransactionCreator, conditions, unsatisfiedProviders);
            unsatisfiedProviders.removeAll(satisfied);
        } while (!satisfied.isEmpty());
        return conditions;
    }

    private Set<DataProvider<Boolean>> attemptToSatisfyMoreConditionsAndStoreResults(Function<MethodWrapper<Boolean>, Callable<Boolean>> methodCaller, BiFunction<MethodWrapper<Boolean>, Boolean, Transaction> storeTransactionCreator, Conditions conditions, List<DataProvider<Boolean>> unsatisfiedProviders) {
        HashSet<DataProvider<Boolean>> satisfied = new HashSet<DataProvider<Boolean>>();
        for (DataProvider<Boolean> booleanProvider : unsatisfiedProviders) {
            ProviderInformation information = booleanProvider.getProviderInformation();
            Optional<String> condition = information.getCondition();
            if (condition.isPresent() && conditions.isNotFulfilled(condition.get())) continue;
            String providedCondition = information.getProvidedCondition();
            MethodWrapper<Boolean> method = booleanProvider.getMethod();
            Boolean result = this.getMethodResult(methodCaller.apply(method), method);
            if (result == null) {
                satisfied.add(booleanProvider);
                continue;
            }
            if (providedCondition != null) {
                if (result.booleanValue()) {
                    conditions.conditionFulfilled(providedCondition);
                } else {
                    conditions.conditionFulfilled("not_" + providedCondition);
                }
            }
            satisfied.add(booleanProvider);
            this.database.executeTransaction(new StoreIconTransaction(information.getIcon()));
            this.database.executeTransaction(new StoreProviderTransaction(booleanProvider, this.serverUUID));
            this.database.executeTransaction(storeTransactionCreator.apply(method, result));
        }
        return satisfied;
    }

    private <T> T getMethodResult(Callable<T> callable, MethodWrapper<T> method) {
        try {
            return callable.call();
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            throw new DataExtensionMethodCallException(e, this.pluginName, method);
        }
    }
}

