/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.providers.gathering;

import com.djrapitops.plan.extension.CallEvents;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.ExtensionWrapper;
import com.djrapitops.plan.extension.implementation.ProviderInformation;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.extension.implementation.providers.DataProviders;
import com.djrapitops.plan.extension.implementation.providers.MethodWrapper;
import com.djrapitops.plan.extension.implementation.providers.Parameters;
import com.djrapitops.plan.extension.implementation.providers.gathering.BooleanProviderValueGatherer;
import com.djrapitops.plan.extension.implementation.providers.gathering.Conditions;
import com.djrapitops.plan.extension.implementation.providers.gathering.TableProviderValueGatherer;
import com.djrapitops.plan.extension.implementation.storage.transactions.StoreIconTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.StorePluginTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.StoreTabInformationTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.providers.StoreProviderTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.RemoveInvalidResultsTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StorePlayerDoubleResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StorePlayerGroupsResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StorePlayerNumberResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StorePlayerStringResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StoreServerDoubleResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StoreServerNumberResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StoreServerStringResultTransaction;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.util.UUID;

public class ProviderValueGatherer {
    private final CallEvents[] callEvents;
    private final ExtensionWrapper extensionWrapper;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final DataProviders dataProviders;
    private final BooleanProviderValueGatherer booleanGatherer;
    private final TableProviderValueGatherer tableGatherer;
    private final Gatherer<Long> serverNumberGatherer;
    private final Gatherer<Long> playerNumberGatherer;
    private final Gatherer<Double> serverDoubleGatherer;
    private final Gatherer<Double> playerDoubleGatherer;
    private final Gatherer<String> serverStringGatherer;
    private final Gatherer<String> playerStringGatherer;
    private final Gatherer<String[]> playerGroupGatherer;

    public ProviderValueGatherer(ExtensionWrapper extension, DBSystem dbSystem, ServerInfo serverInfo) {
        this.callEvents = extension.getCallEvents();
        this.extensionWrapper = extension;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        String pluginName = extension.getPluginName();
        UUID serverUUID = serverInfo.getServerUUID();
        Database database = dbSystem.getDatabase();
        this.dataProviders = extension.getProviders();
        this.booleanGatherer = new BooleanProviderValueGatherer(pluginName, serverUUID, database, extension);
        this.tableGatherer = new TableProviderValueGatherer(pluginName, serverUUID, database, extension);
        this.serverNumberGatherer = new Gatherer<Long>(Long.class, StoreServerNumberResultTransaction::new);
        this.serverDoubleGatherer = new Gatherer<Double>(Double.class, StoreServerDoubleResultTransaction::new);
        this.serverStringGatherer = new Gatherer<String>(String.class, StoreServerStringResultTransaction::new);
        this.playerNumberGatherer = new Gatherer<Long>(Long.class, StorePlayerNumberResultTransaction::new);
        this.playerDoubleGatherer = new Gatherer<Double>(Double.class, StorePlayerDoubleResultTransaction::new);
        this.playerStringGatherer = new Gatherer<String>(String.class, StorePlayerStringResultTransaction::new);
        this.playerGroupGatherer = new Gatherer<String[]>(String[].class, StorePlayerGroupsResultTransaction::new);
    }

    public void disableMethodFromUse(MethodWrapper<?> method) {
        method.disable();
        this.dataProviders.removeProviderWithMethod(method);
    }

    public boolean shouldSkipEvent(CallEvents event) {
        if (event == CallEvents.MANUAL) {
            return false;
        }
        for (CallEvents accepted : this.callEvents) {
            if (event != accepted) continue;
            return false;
        }
        return true;
    }

    public String getPluginName() {
        return this.extensionWrapper.getPluginName();
    }

    public void storeExtensionInformation() {
        String pluginName = this.extensionWrapper.getPluginName();
        Icon pluginIcon = this.extensionWrapper.getPluginIcon();
        long time = System.currentTimeMillis();
        UUID serverUUID = this.serverInfo.getServerUUID();
        Database database = this.dbSystem.getDatabase();
        database.executeTransaction(new StoreIconTransaction(pluginIcon));
        database.executeTransaction(new StorePluginTransaction(pluginName, time, serverUUID, pluginIcon));
        for (TabInformation tab : this.extensionWrapper.getPluginTabs()) {
            database.executeTransaction(new StoreIconTransaction(tab.getTabIcon()));
            database.executeTransaction(new StoreTabInformationTransaction(pluginName, serverUUID, tab));
        }
        database.executeTransaction(new RemoveInvalidResultsTransaction(pluginName, serverUUID, this.extensionWrapper.getInvalidatedMethods()));
    }

    public void updateValues(UUID playerUUID, String playerName) {
        Conditions conditions = this.booleanGatherer.gatherBooleanDataOfPlayer(playerUUID, playerName);
        Parameters params = Parameters.player(this.serverInfo.getServerUUID(), playerUUID, playerName);
        this.playerNumberGatherer.gather(conditions, params);
        this.playerDoubleGatherer.gather(conditions, params);
        this.playerStringGatherer.gather(conditions, params);
        this.tableGatherer.gatherTableDataOfPlayer(playerUUID, playerName, conditions);
        this.playerGroupGatherer.gather(conditions, params);
    }

    public void updateValues() {
        Conditions conditions = this.booleanGatherer.gatherBooleanDataOfServer();
        Parameters params = Parameters.server(this.serverInfo.getServerUUID());
        this.serverNumberGatherer.gather(conditions, params);
        this.serverDoubleGatherer.gather(conditions, params);
        this.serverStringGatherer.gather(conditions, params);
        this.tableGatherer.gatherTableDataOfServer(conditions);
    }

    class Gatherer<T> {
        private final Class<T> type;
        private final ResultTransactionConstructor<T> resultTransactionConstructor;

        public Gatherer(Class<T> type, ResultTransactionConstructor<T> resultTransactionConstructor) {
            this.type = type;
            this.resultTransactionConstructor = resultTransactionConstructor;
        }

        public void gather(Conditions conditions, Parameters parameters) {
            for (DataProvider<T> provider : ProviderValueGatherer.this.dataProviders.getProvidersByTypes(parameters.getMethodType(), this.type)) {
                this.gather(conditions, provider, parameters);
            }
        }

        private void gather(Conditions conditions, DataProvider<T> provider, Parameters parameters) {
            ProviderInformation information = provider.getProviderInformation();
            if (information.getCondition().map(conditions::isNotFulfilled).orElse(false).booleanValue()) {
                return;
            }
            T result = provider.getMethod().callMethod(ProviderValueGatherer.this.extensionWrapper.getExtension(), parameters);
            if (result == null) {
                return;
            }
            Database db = ProviderValueGatherer.this.dbSystem.getDatabase();
            db.executeTransaction(new StoreIconTransaction(information.getIcon()));
            db.executeTransaction(new StoreProviderTransaction(provider, parameters.getServerUUID()));
            db.executeTransaction(this.resultTransactionConstructor.create(provider, parameters, result));
        }
    }

    static interface ResultTransactionConstructor<T> {
        public Transaction create(DataProvider<T> var1, Parameters var2, T var3);
    }
}

