/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.providers.gathering;

import com.djrapitops.plan.exceptions.DataExtensionMethodCallException;
import com.djrapitops.plan.extension.DataExtension;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.ExtensionWrapper;
import com.djrapitops.plan.extension.implementation.ProviderInformation;
import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.extension.implementation.providers.DataProviders;
import com.djrapitops.plan.extension.implementation.providers.MethodWrapper;
import com.djrapitops.plan.extension.implementation.providers.Parameters;
import com.djrapitops.plan.extension.implementation.providers.gathering.Conditions;
import com.djrapitops.plan.extension.implementation.storage.transactions.StoreIconTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.providers.StoreTableProviderTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StorePlayerTableResultTransaction;
import com.djrapitops.plan.extension.implementation.storage.transactions.results.StoreServerTableResultTransaction;
import com.djrapitops.plan.extension.table.Table;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;

class TableProviderValueGatherer {
    private final String pluginName;
    private final DataExtension extension;
    private final UUID serverUUID;
    private final Database database;
    private final DataProviders dataProviders;

    TableProviderValueGatherer(String pluginName, UUID serverUUID, Database database, ExtensionWrapper extensionWrapper) {
        this.pluginName = pluginName;
        this.extension = extensionWrapper.getExtension();
        this.serverUUID = serverUUID;
        this.database = database;
        this.dataProviders = extensionWrapper.getProviders();
    }

    void gatherTableDataOfPlayer(UUID playerUUID, String playerName, Conditions conditions) {
        Function<MethodWrapper<Table>, Callable<Table>> methodCaller = method -> () -> (Table)method.callMethod(this.extension, Parameters.player(this.serverUUID, playerUUID, playerName));
        BiFunction<MethodWrapper<Table>, Table, Transaction> storeTransactionCreator = (method, result) -> new StorePlayerTableResultTransaction(this.pluginName, this.serverUUID, method.getMethodName(), playerUUID, (Table)result);
        for (DataProvider<Table> tableProvider : this.dataProviders.getPlayerMethodsByType(Table.class)) {
            this.gatherTableDataOfProvider(methodCaller, storeTransactionCreator, conditions, tableProvider);
        }
    }

    void gatherTableDataOfServer(Conditions conditions) {
        Function<MethodWrapper<Table>, Callable<Table>> methodCaller = method -> () -> (Table)method.callMethod(this.extension, Parameters.server(this.serverUUID));
        BiFunction<MethodWrapper<Table>, Table, Transaction> storeTransactionCreator = (method, result) -> new StoreServerTableResultTransaction(this.pluginName, this.serverUUID, method.getMethodName(), (Table)result);
        for (DataProvider<Table> tableProvider : this.dataProviders.getServerMethodsByType(Table.class)) {
            this.gatherTableDataOfProvider(methodCaller, storeTransactionCreator, conditions, tableProvider);
        }
    }

    private void gatherTableDataOfProvider(Function<MethodWrapper<Table>, Callable<Table>> methodCaller, BiFunction<MethodWrapper<Table>, Table, Transaction> storeTransactionCreator, Conditions conditions, DataProvider<Table> tableProvider) {
        ProviderInformation providerInformation = tableProvider.getProviderInformation();
        Optional<String> condition = providerInformation.getCondition();
        if (condition.isPresent() && conditions.isNotFulfilled(condition.get())) {
            return;
        }
        MethodWrapper<Table> method = tableProvider.getMethod();
        Table result = this.getMethodResult(methodCaller.apply(method), method);
        if (result == null) {
            return;
        }
        for (Icon icon : result.getIcons()) {
            if (icon == null) continue;
            this.database.executeTransaction(new StoreIconTransaction(icon));
        }
        this.database.executeTransaction(new StoreTableProviderTransaction(this.serverUUID, providerInformation, result));
        this.database.executeTransaction(storeTransactionCreator.apply(method, result));
    }

    private <T> T getMethodResult(Callable<T> callable, MethodWrapper<T> method) {
        try {
            return callable.call();
        }
        catch (Exception | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            throw new DataExtensionMethodCallException(e, this.pluginName, method);
        }
    }
}

