/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.results;

import com.djrapitops.plan.extension.implementation.results.ExtensionInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExtensionData
implements Comparable<ExtensionData> {
    private final int pluginID;
    private ExtensionInformation extensionInformation;
    private final Map<String, ExtensionTabData> tabs;

    private ExtensionData(int pluginID) {
        this.pluginID = pluginID;
        this.tabs = new HashMap<String, ExtensionTabData>();
    }

    public int getPluginID() {
        return this.pluginID;
    }

    public ExtensionInformation getExtensionInformation() {
        return this.extensionInformation;
    }

    public boolean hasOnlyGenericTab() {
        return this.tabs.size() == 1 && this.tabs.containsKey("");
    }

    public boolean doesNeedWiderSpace() {
        for (ExtensionTabData tab : this.tabs.values()) {
            for (ExtensionTableData table : tab.getTableData()) {
                if (!table.isWideTable()) continue;
                return true;
            }
        }
        return false;
    }

    public List<ExtensionTabData> getTabs() {
        ArrayList<ExtensionTabData> tabList = new ArrayList<ExtensionTabData>(this.tabs.values());
        Collections.sort(tabList);
        return tabList;
    }

    @Override
    public int compareTo(ExtensionData o) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.extensionInformation.getPluginName(), o.extensionInformation.getPluginName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensionData)) {
            return false;
        }
        ExtensionData that = (ExtensionData)o;
        return this.pluginID == that.pluginID && Objects.equals(this.extensionInformation, that.extensionInformation) && Objects.equals(this.tabs, that.tabs);
    }

    public int hashCode() {
        return Objects.hash(this.pluginID, this.extensionInformation, this.tabs);
    }

    public String toString() {
        return "ExtensionData{pluginID=" + this.pluginID + ", extensionInformation=" + this.extensionInformation + ", tabs=" + this.tabs + '}';
    }

    public static class Builder {
        private final ExtensionData data;

        public Builder(int pluginId) {
            this.data = new ExtensionData(pluginId);
        }

        public Builder combine(Builder with) {
            if (with != null) {
                for (ExtensionTabData tab : with.build().getTabs()) {
                    Optional<ExtensionTabData> found = this.getTab(tab.getTabInformation().getTabName());
                    if (found.isPresent()) {
                        found.get().combine(tab);
                        continue;
                    }
                    this.addTab(tab);
                }
            }
            return this;
        }

        public Builder setInformation(ExtensionInformation information) {
            if (information.getId() != this.data.pluginID) {
                throw new IllegalArgumentException("ID mismatch, wanted id: " + this.data.pluginID + " but got " + information);
            }
            this.data.extensionInformation = information;
            return this;
        }

        public Builder addTab(ExtensionTabData tab) {
            this.data.tabs.put(tab.getTabInformation().getTabName(), tab);
            return this;
        }

        public Optional<ExtensionTabData> getTab(String tabName) {
            return Optional.ofNullable(this.data.tabs.get(tabName));
        }

        public ExtensionData build() {
            return this.data;
        }
    }
}

