/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.results;

import com.djrapitops.plan.extension.icon.Icon;
import java.util.Objects;
import java.util.Optional;
import plan.org.apache.commons.lang3.StringUtils;

public class ExtensionDescriptive
implements Comparable<ExtensionDescriptive> {
    private final String name;
    private final String text;
    private final String description;
    private final Icon icon;
    private final int priority;

    public ExtensionDescriptive(String name, String text, String description, Icon icon, int priority) {
        this.name = name;
        this.text = text;
        this.description = description;
        this.icon = icon;
        this.priority = priority;
    }

    public String getName() {
        return StringUtils.truncate(this.name, 50);
    }

    public String getText() {
        return StringUtils.truncate(this.text, 50);
    }

    public Optional<String> getDescription() {
        return this.description == null || this.description.isEmpty() ? Optional.empty() : Optional.of(StringUtils.truncate(this.description, 150));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(ExtensionDescriptive other) {
        return Integer.compare(other.priority, this.priority);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensionDescriptive)) {
            return false;
        }
        ExtensionDescriptive that = (ExtensionDescriptive)o;
        return this.priority == that.priority && this.name.equals(that.name) && this.text.equals(that.text) && Objects.equals(this.description, that.description) && this.icon.equals(that.icon);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.text, this.description, this.icon, this.priority);
    }

    public String toString() {
        return "ExtensionDescriptive{name='" + this.name + '\'' + ", text='" + this.text + '\'' + ", description='" + this.description + '\'' + ", icon=" + this.icon + ", priority=" + this.priority + '}';
    }
}

