/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.results;

import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.extension.implementation.results.DescribedExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import java.io.Serializable;

public class ExtensionStringData
implements DescribedExtensionData {
    private final ExtensionDescriptive descriptive;
    private final boolean playerName;
    private String value;

    public ExtensionStringData(ExtensionDescriptive descriptive, boolean playerName, String value) {
        this.descriptive = descriptive;
        this.playerName = playerName;
        this.value = value;
    }

    @Override
    public ExtensionDescriptive getDescriptive() {
        return this.descriptive;
    }

    public String getFormattedValue() {
        String withColors = Html.swapColorCodesToSpan(this.value);
        return !this.playerName ? withColors : Html.LINK.create(new Serializable[]{"../player/" + Html.encodeToURL(this.value), withColors});
    }

    ExtensionStringData concatenate(ExtensionStringData other) {
        this.value = this.value + ", " + other.value;
        return this;
    }
}

