/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.results;

import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.DescribedExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionBooleanData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionDoubleData;
import com.djrapitops.plan.extension.implementation.results.ExtensionNumberData;
import com.djrapitops.plan.extension.implementation.results.ExtensionStringData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTableData;
import com.djrapitops.plan.utilities.java.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExtensionTabData
implements Comparable<ExtensionTabData> {
    private final TabInformation tabInformation;
    private final Map<String, ExtensionBooleanData> booleanData;
    private final Map<String, ExtensionDoubleData> doubleData;
    private final Map<String, ExtensionDoubleData> percentageData;
    private final Map<String, ExtensionNumberData> numberData;
    private final Map<String, ExtensionStringData> stringData;
    private final List<ExtensionTableData> tableData;
    private final List<ExtensionDescriptive> descriptives;
    private List<String> order;

    public ExtensionTabData(TabInformation tabInformation) {
        this.tabInformation = tabInformation;
        this.booleanData = new HashMap<String, ExtensionBooleanData>();
        this.doubleData = new HashMap<String, ExtensionDoubleData>();
        this.percentageData = new HashMap<String, ExtensionDoubleData>();
        this.numberData = new HashMap<String, ExtensionNumberData>();
        this.stringData = new HashMap<String, ExtensionStringData>();
        this.tableData = new ArrayList<ExtensionTableData>();
        this.descriptives = new ArrayList<ExtensionDescriptive>();
    }

    public TabInformation getTabInformation() {
        return this.tabInformation;
    }

    public List<String> getValueOrder() {
        return this.order;
    }

    public Optional<ExtensionBooleanData> getBoolean(String providerName) {
        return Optional.ofNullable(this.booleanData.get(providerName));
    }

    public Optional<ExtensionDoubleData> getDouble(String providerName) {
        return Optional.ofNullable(this.doubleData.get(providerName));
    }

    public Optional<ExtensionDoubleData> getPercentage(String providerName) {
        return Optional.ofNullable(this.percentageData.get(providerName));
    }

    public Optional<ExtensionNumberData> getNumber(String providerName) {
        return Optional.ofNullable(this.numberData.get(providerName));
    }

    public Optional<ExtensionStringData> getString(String providerName) {
        return Optional.ofNullable(this.stringData.get(providerName));
    }

    public List<ExtensionTableData> getTableData() {
        return this.tableData;
    }

    public List<ExtensionDescriptive> getDescriptives() {
        return this.descriptives;
    }

    @Override
    public int compareTo(ExtensionTabData other) {
        return Integer.compare(this.tabInformation.getTabPriority(), other.tabInformation.getTabPriority());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensionTabData)) {
            return false;
        }
        ExtensionTabData that = (ExtensionTabData)o;
        return this.tabInformation.equals(that.tabInformation) && this.order.equals(that.order);
    }

    public int hashCode() {
        return Objects.hash(this.tabInformation, this.order);
    }

    public void combine(ExtensionTabData other) {
        this.booleanData.putAll(other.booleanData);
        this.doubleData.putAll(other.doubleData);
        this.percentageData.putAll(other.percentageData);
        this.numberData.putAll(other.numberData);
        this.stringData.putAll(other.stringData);
        this.tableData.addAll(other.tableData);
        this.createOrderingList();
    }

    private void createOrderingList() {
        this.descriptives.addAll(Lists.map(this.booleanData.values(), DescribedExtensionData::getDescriptive));
        this.descriptives.addAll(Lists.map(this.doubleData.values(), DescribedExtensionData::getDescriptive));
        this.descriptives.addAll(Lists.map(this.percentageData.values(), DescribedExtensionData::getDescriptive));
        this.descriptives.addAll(Lists.map(this.numberData.values(), DescribedExtensionData::getDescriptive));
        this.descriptives.addAll(Lists.map(this.stringData.values(), DescribedExtensionData::getDescriptive));
        this.order = this.descriptives.stream().sorted().map(ExtensionDescriptive::getName).distinct().collect(Collectors.toList());
    }

    public String toString() {
        return "ExtensionTabData{tabInformation=" + this.tabInformation + ", tableData=" + this.tableData + ", descriptives=" + this.descriptives + '}';
    }

    public static class Builder {
        private final ExtensionTabData data;

        public Builder(TabInformation tabInformation) {
            this.data = new ExtensionTabData(tabInformation);
        }

        public Builder putBooleanData(ExtensionBooleanData extensionBooleanData) {
            this.data.booleanData.put(extensionBooleanData.getDescriptive().getName(), extensionBooleanData);
            return this;
        }

        public Builder putDoubleData(ExtensionDoubleData extensionDoubleData) {
            this.data.doubleData.put(extensionDoubleData.getDescriptive().getName(), extensionDoubleData);
            return this;
        }

        public Builder putPercentageData(ExtensionDoubleData extensionDoubleData) {
            this.data.percentageData.put(extensionDoubleData.getDescriptive().getName(), extensionDoubleData);
            return this;
        }

        public Builder putNumberData(ExtensionNumberData extensionNumberData) {
            this.data.numberData.put(extensionNumberData.getDescriptive().getName(), extensionNumberData);
            return this;
        }

        public Builder putStringData(ExtensionStringData extensionStringData) {
            this.data.stringData.put(extensionStringData.getDescriptive().getName(), extensionStringData);
            return this;
        }

        public Builder putGroupData(ExtensionStringData extensionStringData) {
            String name = extensionStringData.getDescriptive().getName();
            ExtensionStringData previous = (ExtensionStringData)this.data.stringData.get(name);
            this.data.stringData.put(name, previous != null ? previous.concatenate(extensionStringData) : extensionStringData);
            return this;
        }

        public Builder putTableData(ExtensionTableData extensionTableData) {
            this.data.tableData.add(extensionTableData);
            return this;
        }

        public ExtensionTabData build() {
            this.data.createOrderingList();
            Collections.sort(this.data.tableData);
            return this.data;
        }
    }
}

