/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.results;

import com.djrapitops.plan.data.element.TableContainer;
import com.djrapitops.plan.delivery.rendering.html.icon.Color;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.table.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ExtensionTableData
implements Comparable<ExtensionTableData> {
    private final String providerName;
    private final Table table;
    private final com.djrapitops.plan.extension.icon.Color tableColor;

    public ExtensionTableData(String providerName, Table table, com.djrapitops.plan.extension.icon.Color tableColor) {
        this.providerName = providerName;
        this.table = table;
        this.tableColor = tableColor;
    }

    public TableContainer getHtmlTable() {
        String[] columns = this.table.getColumns();
        Icon[] icons = this.table.getIcons();
        List<Object[]> rows = this.table.getRows();
        String[] header = this.buildHeader(columns, icons);
        TableContainer htmlTable = new TableContainer(header);
        if (rows.size() > 50) {
            htmlTable.useJqueryDataTables();
        } else {
            String colorName = Color.getByName(this.tableColor.name()).orElse(Color.NONE).getHtmlClass().replace("col-", "");
            htmlTable.setColor(colorName);
        }
        for (Object[] row : rows) {
            htmlTable.addRow((Serializable[])Arrays.stream(row).map(value -> value != null ? value.toString() : null).toArray(Serializable[]::new));
        }
        return htmlTable;
    }

    private String[] buildHeader(String[] columns, Icon[] icons) {
        String column;
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < columns.length && (column = columns[i]) != null; ++i) {
            header.add(com.djrapitops.plan.delivery.rendering.html.icon.Icon.fromExtensionIcon(icons[i]).toHtml() + ' ' + column);
        }
        return header.toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensionTableData)) {
            return false;
        }
        ExtensionTableData that = (ExtensionTableData)o;
        return this.providerName.equals(that.providerName) && this.tableColor == that.tableColor;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.providerName, this.tableColor});
    }

    public String toString() {
        return "ExtensionTableData{providerName='" + this.providerName + '\'' + '}';
    }

    @Override
    public int compareTo(ExtensionTableData other) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.providerName, other.providerName);
    }

    public boolean isWideTable() {
        return this.table.getMaxColumnSize() >= 3;
    }
}

