/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionDoubleData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.extension.implementation.storage.queries.QueriedTabData;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ExtensionAggregateBooleansQuery
implements Query<Map<Integer, ExtensionData.Builder>> {
    private final UUID serverUUID;

    public ExtensionAggregateBooleansQuery(UUID serverUUID) {
        this.serverUUID = serverUUID;
    }

    @Override
    public Map<Integer, ExtensionData.Builder> executeQuery(SQLDB db) {
        String selectTrueBooleans = "SELECT provider_id,COUNT(1) as positive FROM plan_extension_user_values WHERE boolean_value=? GROUP BY provider_id";
        String selectBooleanCount = "SELECT provider_id,COUNT(1) as total FROM plan_extension_user_values WHERE boolean_value IS NOT NULL GROUP BY provider_id";
        String sql = "SELECT b1.total as total,b2.positive as positive,p1.plugin_id as plugin_id,p1.name as provider_name,p1.text as text,p1.description as description,p1.priority as provider_priority,p1.player_name as is_player_name,t1.name as tab_name,t1.tab_priority as tab_priority,t1.element_order as element_order,i1.name as provider_icon_name,i1.family as provider_icon_family,i1.color as provider_icon_color,i2.name as tab_icon_name,i2.family as tab_icon_family,i2.color as tab_icon_color FROM (" + selectBooleanCount + ") b1" + " JOIN " + "plan_extension_providers" + " p1 on p1." + "id" + "=b1." + "provider_id" + " JOIN " + "plan_extension_plugins" + " e1 on p1." + "plugin_id" + "=e1." + "id" + " LEFT JOIN " + '(' + selectTrueBooleans + ") b2 on b2." + "provider_id" + "=b1." + "provider_id" + " LEFT JOIN " + "plan_extension_tabs" + " t1 on t1." + "id" + "=p1." + "tab_id" + " LEFT JOIN " + "plan_extension_icons" + " i1 on i1." + "id" + "=p1." + "icon_id" + " LEFT JOIN " + "plan_extension_icons" + " i2 on i2." + "id" + "=p1." + "icon_id" + " WHERE " + "server_uuid" + "=?" + " AND " + "p1." + "hidden" + "=?";
        return db.query(new QueryStatement<Map<Integer, ExtensionData.Builder>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
                statement.setString(2, ExtensionAggregateBooleansQuery.this.serverUUID.toString());
                statement.setBoolean(3, false);
            }

            @Override
            public Map<Integer, ExtensionData.Builder> processResults(ResultSet set) throws SQLException {
                return ExtensionAggregateBooleansQuery.this.extractTabDataByPluginID(set).toExtensionDataByPluginID();
            }
        });
    }

    private QueriedTabData extractTabDataByPluginID(ResultSet set) throws SQLException {
        QueriedTabData tabData = new QueriedTabData();
        while (set.next()) {
            int pluginID = set.getInt("plugin_id");
            String tabName = Optional.ofNullable(set.getString("tab_name")).orElse("");
            ExtensionTabData.Builder extensionTab = tabData.getTab(pluginID, tabName, () -> this.extractTabInformation(tabName, set));
            ExtensionDescriptive extensionDescriptive = this.extractDescriptive(set);
            this.extractAndPutDataTo(extensionTab, extensionDescriptive, set);
        }
        return tabData;
    }

    private TabInformation extractTabInformation(String tabName, ResultSet set) throws SQLException {
        Optional<Integer> tabPriority = Optional.of(set.getInt("tab_priority"));
        if (set.wasNull()) {
            tabPriority = Optional.empty();
        }
        Optional<ElementOrder[]> elementOrder = Optional.ofNullable(set.getString("element_order")).map(ElementOrder::deserialize);
        Icon tabIcon = this.extractTabIcon(set);
        return new TabInformation(tabName, tabIcon, elementOrder.orElse(ElementOrder.values()), tabPriority.orElse(100));
    }

    private void extractAndPutDataTo(ExtensionTabData.Builder extensionTab, ExtensionDescriptive descriptive, ResultSet set) throws SQLException {
        double percentageValue = this.percentage(set.getInt("positive"), set.getInt("total"));
        extensionTab.putPercentageData(new ExtensionDoubleData(descriptive, percentageValue));
    }

    private double percentage(double first, double second) {
        if (first == 0.0 || second == 0.0) {
            return 0.0;
        }
        return first / second;
    }

    private ExtensionDescriptive extractDescriptive(ResultSet set) throws SQLException {
        String name = set.getString("provider_name") + "_aggregate";
        String text = set.getString("text") + " / Players";
        String description = set.getString("description");
        int priority = set.getInt("provider_priority");
        String iconName = set.getString("provider_icon_name");
        Family family = Family.getByName(set.getString("provider_icon_family")).orElse(Family.SOLID);
        Color color = Color.getByName(set.getString("provider_icon_color")).orElse(Color.NONE);
        Icon icon = new Icon(family, iconName, color);
        return new ExtensionDescriptive(name, text, description, icon, priority);
    }

    private Icon extractTabIcon(ResultSet set) throws SQLException {
        Optional<String> iconName = Optional.ofNullable(set.getString("tab_icon_name"));
        if (iconName.isPresent()) {
            Family iconFamily = Family.getByName(set.getString("tab_icon_family")).orElse(Family.SOLID);
            Color iconColor = Color.getByName(set.getString("tab_icon_color")).orElse(Color.NONE);
            return new Icon(iconFamily, iconName.get(), iconColor);
        }
        return TabInformation.defaultIcon();
    }
}

