/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.storage.queries.QueriedTables;
import com.djrapitops.plan.extension.table.Table;
import com.djrapitops.plan.extension.table.TableAccessor;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ExtensionAggregateGroupsQuery
implements Query<Map<Integer, ExtensionData.Builder>> {
    private final UUID serverUUID;

    public ExtensionAggregateGroupsQuery(UUID serverUUID) {
        this.serverUUID = serverUUID;
    }

    @Override
    public Map<Integer, ExtensionData.Builder> executeQuery(SQLDB db) {
        String selectGroupCounts = "SELECT provider_id,group_name,COUNT(1) as count FROM plan_extension_groups GROUP BY group_name,provider_id";
        String sql = "SELECT b1.group_name as group_name,b1.count as count,p1.id as table_id,p1.plugin_id as plugin_id,p1.name as table_name,p1.text as col_1_name,t1.name as tab_name,t1.tab_priority as tab_priority,t1.element_order as element_order,i1.name as i1_name,i1.family as i1_family,i1.color as table_color,i2.name as tab_icon_name,i2.family as tab_icon_family,i2.color as tab_icon_color FROM (" + selectGroupCounts + ") b1" + " JOIN " + "plan_extension_providers" + " p1 on p1." + "id" + "=b1." + "provider_id" + " JOIN " + "plan_extension_plugins" + " e1 on p1." + "plugin_id" + "=e1." + "id" + " LEFT JOIN " + "plan_extension_tabs" + " t1 on t1." + "id" + "=p1." + "tab_id" + " LEFT JOIN " + "plan_extension_icons" + " i1 on i1." + "id" + "=p1." + "icon_id" + " LEFT JOIN " + "plan_extension_icons" + " i2 on i2." + "id" + "=p1." + "icon_id" + " WHERE " + "server_uuid" + "=?" + " AND " + "p1." + "hidden" + "=?" + " ORDER BY " + "table_id ASC, group_name ASC";
        return db.query(new QueryStatement<Map<Integer, ExtensionData.Builder>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, ExtensionAggregateGroupsQuery.this.serverUUID.toString());
                statement.setBoolean(2, false);
            }

            @Override
            public Map<Integer, ExtensionData.Builder> processResults(ResultSet set) throws SQLException {
                return ExtensionAggregateGroupsQuery.this.extractTables(set).toQueriedTabs().toExtensionDataByPluginID();
            }
        });
    }

    private QueriedTables extractTables(ResultSet set) throws SQLException {
        QueriedTables tables = new QueriedTables();
        while (set.next()) {
            int tableID;
            int pluginID = set.getInt("plugin_id");
            if (!tables.contains(pluginID, tableID = set.getInt("table_id"))) {
                tables.put(pluginID, tableID, this.extractTable(set));
            }
            tables.addRow(pluginID, tableID, set.getString("group_name"), set.getInt("count"));
        }
        return tables;
    }

    private Table.Factory extractTable(ResultSet set) throws SQLException {
        Table.Factory table = Table.builder();
        this.extractColumns(set, table);
        TableAccessor.setColor(table, Color.getByName(set.getString("table_color")).orElse(Color.NONE));
        TableAccessor.setTableName(table, set.getString("table_name"));
        TableAccessor.setTabName(table, Optional.ofNullable(set.getString("tab_name")).orElse(""));
        TableAccessor.setTabPriority(table, Optional.of(set.getInt("tab_priority")).orElse(100));
        TableAccessor.setTabOrder(table, Optional.ofNullable(set.getString("element_order")).map(ElementOrder::deserialize).orElse(ElementOrder.values()));
        TableAccessor.setTabIcon(table, this.extractIcon(set, "tab_icon"));
        return table;
    }

    private void extractColumns(ResultSet set, Table.Factory table) throws SQLException {
        String col1 = set.getString("col_1_name");
        if (col1 != null) {
            table.columnOne(col1, this.extractIcon(set, "i1"));
        }
        table.columnTwo("Players", Icon.called("user").build());
    }

    private Icon extractIcon(ResultSet set, String iconColumnName) throws SQLException {
        String iconName = set.getString(iconColumnName + "_name");
        if (iconName == null) {
            return null;
        }
        return new Icon(Family.getByName(set.getString(iconColumnName + "_family")).orElse(Family.SOLID), iconName, Color.NONE);
    }
}

