/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionDoubleData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.extension.implementation.storage.queries.QueriedTabData;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ExtensionAggregatePercentagesQuery
implements Query<Map<Integer, ExtensionData.Builder>> {
    private final UUID serverUUID;

    public ExtensionAggregatePercentagesQuery(UUID serverUUID) {
        this.serverUUID = serverUUID;
    }

    @Override
    public Map<Integer, ExtensionData.Builder> executeQuery(SQLDB db) {
        String selectPercentageAverage = "SELECT provider_id,AVG(percentage_value) as average FROM plan_extension_user_values WHERE percentage_value IS NOT NULL GROUP BY provider_id";
        String sql = "SELECT b1.average as average,p1.plugin_id as plugin_id,p1.name as provider_name,p1.text as text,p1.description as description,p1.priority as provider_priority,p1.player_name as is_player_name,t1.name as tab_name,t1.tab_priority as tab_priority,t1.element_order as element_order,i1.name as provider_icon_name,i1.family as provider_icon_family,i1.color as provider_icon_color,i2.name as tab_icon_name,i2.family as tab_icon_family,i2.color as tab_icon_color FROM (" + selectPercentageAverage + ") b1" + " JOIN " + "plan_extension_providers" + " p1 on p1." + "id" + "=b1." + "provider_id" + " JOIN " + "plan_extension_plugins" + " e1 on p1." + "plugin_id" + "=e1." + "id" + " LEFT JOIN " + "plan_extension_tabs" + " t1 on t1." + "id" + "=p1." + "tab_id" + " LEFT JOIN " + "plan_extension_icons" + " i1 on i1." + "id" + "=p1." + "icon_id" + " LEFT JOIN " + "plan_extension_icons" + " i2 on i2." + "id" + "=p1." + "icon_id" + " WHERE " + "server_uuid" + "=?" + " AND " + "p1." + "hidden" + "=?";
        return db.query(new QueryStatement<Map<Integer, ExtensionData.Builder>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, ExtensionAggregatePercentagesQuery.this.serverUUID.toString());
                statement.setBoolean(2, false);
            }

            @Override
            public Map<Integer, ExtensionData.Builder> processResults(ResultSet set) throws SQLException {
                return ExtensionAggregatePercentagesQuery.this.extractTabDataByPluginID(set).toExtensionDataByPluginID();
            }
        });
    }

    private QueriedTabData extractTabDataByPluginID(ResultSet set) throws SQLException {
        QueriedTabData tabData = new QueriedTabData();
        while (set.next()) {
            int pluginID = set.getInt("plugin_id");
            String tabName = Optional.ofNullable(set.getString("tab_name")).orElse("");
            ExtensionTabData.Builder extensionTab = tabData.getTab(pluginID, tabName, () -> this.extractTabInformation(tabName, set));
            ExtensionDescriptive extensionDescriptive = this.extractDescriptive(set);
            this.extractAndPutDataTo(extensionTab, extensionDescriptive, set);
        }
        return tabData;
    }

    private TabInformation extractTabInformation(String tabName, ResultSet set) throws SQLException {
        Optional<Integer> tabPriority = Optional.of(set.getInt("tab_priority"));
        if (set.wasNull()) {
            tabPriority = Optional.empty();
        }
        Optional<ElementOrder[]> elementOrder = Optional.ofNullable(set.getString("element_order")).map(ElementOrder::deserialize);
        Icon tabIcon = this.extractTabIcon(set);
        return new TabInformation(tabName, tabIcon, elementOrder.orElse(ElementOrder.values()), tabPriority.orElse(100));
    }

    private void extractAndPutDataTo(ExtensionTabData.Builder extensionTab, ExtensionDescriptive descriptive, ResultSet set) throws SQLException {
        extensionTab.putPercentageData(new ExtensionDoubleData(this.modifiedDescriptive(descriptive, "_avg", "Average "), set.getDouble("average")));
    }

    private ExtensionDescriptive modifiedDescriptive(ExtensionDescriptive descriptive, String appendToName, String appendToText) {
        return new ExtensionDescriptive(descriptive.getName() + appendToName, appendToText + descriptive.getText(), descriptive.getDescription().orElse(null), descriptive.getIcon(), descriptive.getPriority());
    }

    private ExtensionDescriptive extractDescriptive(ResultSet set) throws SQLException {
        String name = set.getString("provider_name");
        String text = set.getString("text");
        String description = set.getString("description");
        int priority = set.getInt("provider_priority");
        String iconName = set.getString("provider_icon_name");
        Family family = Family.getByName(set.getString("provider_icon_family")).orElse(Family.SOLID);
        Color color = Color.getByName(set.getString("provider_icon_color")).orElse(Color.NONE);
        Icon icon = new Icon(family, iconName, color);
        return new ExtensionDescriptive(name, text, description, icon, priority);
    }

    private Icon extractTabIcon(ResultSet set) throws SQLException {
        Optional<String> iconName = Optional.ofNullable(set.getString("tab_icon_name"));
        if (iconName.isPresent()) {
            Family iconFamily = Family.getByName(set.getString("tab_icon_family")).orElse(Family.SOLID);
            Color iconColor = Color.getByName(set.getString("tab_icon_color")).orElse(Color.NONE);
            return new Icon(iconFamily, iconName.get(), iconColor);
        }
        return TabInformation.defaultIcon();
    }
}

