/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.results.ExtensionInformation;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryAllStatement;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.utilities.java.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ExtensionInformationQueries {
    private ExtensionInformationQueries() {
    }

    public static Query<List<ExtensionInformation>> extensionsOfServer(final UUID serverUUID) {
        String sql = "SELECT plan_extension_plugins.id as id,plan_extension_plugins.name as plugin_name,plan_extension_icons.name as icon_name,color,family FROM plan_extension_plugins JOIN plan_extension_icons on icon_id=plan_extension_icons.id WHERE server_uuid=?";
        return new QueryStatement<List<ExtensionInformation>>(sql, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, serverUUID.toString());
            }

            @Override
            public List<ExtensionInformation> processResults(ResultSet set) throws SQLException {
                ArrayList<ExtensionInformation> information = new ArrayList<ExtensionInformation>();
                while (set.next()) {
                    information.add(ExtensionInformationQueries.extractExtensionInformationFromQuery(set));
                }
                return information;
            }
        };
    }

    private static ExtensionInformation extractExtensionInformationFromQuery(ResultSet set) throws SQLException {
        int id = set.getInt("id");
        String pluginName = set.getString("plugin_name");
        String iconName = set.getString("icon_name");
        Family iconFamily = Family.getByName(set.getString("family")).orElse(Family.SOLID);
        Color color = Color.getByName(set.getString("color")).orElse(Color.NONE);
        Icon icon = new Icon(iconFamily, iconName, color);
        return new ExtensionInformation(id, pluginName, icon);
    }

    public static Query<Map<UUID, List<ExtensionInformation>>> allExtensions() {
        String sql = "SELECT plan_extension_plugins.id as id,plan_extension_plugins.name as plugin_name,server_uuid,plan_extension_icons.name as icon_name,color,family FROM plan_extension_plugins JOIN plan_extension_icons on icon_id=plan_extension_icons.id";
        return new QueryAllStatement<Map<UUID, List<ExtensionInformation>>>(sql, 100){

            @Override
            public Map<UUID, List<ExtensionInformation>> processResults(ResultSet set) throws SQLException {
                HashMap<UUID, List<ExtensionInformation>> byServerUUID = new HashMap<UUID, List<ExtensionInformation>>();
                while (set.next()) {
                    UUID serverUUID = UUID.fromString(set.getString("server_uuid"));
                    List information = byServerUUID.computeIfAbsent(serverUUID, Lists::create);
                    information.add(ExtensionInformationQueries.extractExtensionInformationFromQuery(set));
                }
                return byServerUUID;
            }
        };
    }
}

