/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionBooleanData;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionDoubleData;
import com.djrapitops.plan.extension.implementation.results.ExtensionInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionNumberData;
import com.djrapitops.plan.extension.implementation.results.ExtensionStringData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionInformationQueries;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionPlayerGroupsQuery;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionPlayerTablesQuery;
import com.djrapitops.plan.extension.implementation.storage.queries.QueriedTabData;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.utilities.java.Lists;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ExtensionPlayerDataQuery
implements Query<Map<UUID, List<ExtensionData>>> {
    private final UUID playerUUID;

    public ExtensionPlayerDataQuery(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Override
    public Map<UUID, List<ExtensionData>> executeQuery(SQLDB db) {
        Map<UUID, List<ExtensionInformation>> extensionsByServerUUID = db.query(ExtensionInformationQueries.allExtensions());
        Map<Integer, ExtensionData.Builder> extensionDataByPluginID = db.query(this.fetchIncompletePlayerDataByPluginID());
        this.combine(extensionDataByPluginID, db.query(new ExtensionPlayerTablesQuery(this.playerUUID)));
        this.combine(extensionDataByPluginID, db.query(new ExtensionPlayerGroupsQuery(this.playerUUID)));
        return this.flatMapByServerUUID(extensionsByServerUUID, extensionDataByPluginID);
    }

    private void combine(Map<Integer, ExtensionData.Builder> extensionDataByPluginID, Map<Integer, ExtensionData.Builder> aggregates) {
        for (Map.Entry<Integer, ExtensionData.Builder> entry : aggregates.entrySet()) {
            Integer pluginID = entry.getKey();
            ExtensionData.Builder data = entry.getValue();
            ExtensionData.Builder found = extensionDataByPluginID.get(pluginID);
            if (found == null) {
                extensionDataByPluginID.put(pluginID, data);
                continue;
            }
            found.combine(data);
        }
    }

    private Map<UUID, List<ExtensionData>> flatMapByServerUUID(Map<UUID, List<ExtensionInformation>> extensionsByServerUUID, Map<Integer, ExtensionData.Builder> extensionDataByPluginID) {
        HashMap<UUID, List<ExtensionData>> extensionDataByServerUUID = new HashMap<UUID, List<ExtensionData>>();
        for (Map.Entry<UUID, List<ExtensionInformation>> entry : extensionsByServerUUID.entrySet()) {
            UUID serverUUID = entry.getKey();
            for (ExtensionInformation extensionInformation : entry.getValue()) {
                ExtensionData.Builder data = extensionDataByPluginID.get(extensionInformation.getId());
                if (data == null) continue;
                List list = extensionDataByServerUUID.computeIfAbsent(serverUUID, Lists::create);
                list.add(data.setInformation(extensionInformation).build());
            }
        }
        return extensionDataByServerUUID;
    }

    private Query<Map<Integer, ExtensionData.Builder>> fetchIncompletePlayerDataByPluginID() {
        String sql = "SELECT v1.boolean_value as boolean_value,v1.double_value as double_value,v1.percentage_value as percentage_value,v1.long_value as long_value,v1.string_value as string_value,p1.plugin_id as plugin_id,p1.name as provider_name,p1.text as text,p1.description as description,p1.priority as provider_priority,p1.format_type as format_type,p1.player_name as is_player_name,t1.name as tab_name,t1.tab_priority as tab_priority,t1.element_order as element_order,i1.name as provider_icon_name,i1.family as provider_icon_family,i1.color as provider_icon_color,i2.name as tab_icon_name,i2.family as tab_icon_family,i2.color as tab_icon_color FROM plan_extension_user_values v1 JOIN plan_extension_providers p1 on p1.id=v1.provider_id LEFT JOIN plan_extension_tabs t1 on t1.id=p1.tab_id LEFT JOIN plan_extension_icons i1 on i1.id=p1.icon_id LEFT JOIN plan_extension_icons i2 on i2.id=p1.icon_id WHERE uuid=? AND p1.hidden=?";
        return new QueryStatement<Map<Integer, ExtensionData.Builder>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, ExtensionPlayerDataQuery.this.playerUUID.toString());
                statement.setBoolean(2, false);
            }

            @Override
            public Map<Integer, ExtensionData.Builder> processResults(ResultSet set) throws SQLException {
                return ExtensionPlayerDataQuery.this.extractTabDataByPluginID(set).toExtensionDataByPluginID();
            }
        };
    }

    private QueriedTabData extractTabDataByPluginID(ResultSet set) throws SQLException {
        QueriedTabData tabData = new QueriedTabData();
        while (set.next()) {
            int pluginID = set.getInt("plugin_id");
            String tabName = Optional.ofNullable(set.getString("tab_name")).orElse("");
            ExtensionTabData.Builder extensionTab = tabData.getTab(pluginID, tabName, () -> this.extractTabInformation(tabName, set));
            ExtensionDescriptive extensionDescriptive = this.extractDescriptive(set);
            this.extractAndPutDataTo(extensionTab, extensionDescriptive, set);
        }
        return tabData;
    }

    private TabInformation extractTabInformation(String tabName, ResultSet set) throws SQLException {
        Optional<Integer> tabPriority = Optional.of(set.getInt("tab_priority"));
        if (set.wasNull()) {
            tabPriority = Optional.empty();
        }
        Optional<ElementOrder[]> elementOrder = Optional.ofNullable(set.getString("element_order")).map(ElementOrder::deserialize);
        Icon tabIcon = this.extractTabIcon(set);
        return new TabInformation(tabName, tabIcon, elementOrder.orElse(ElementOrder.values()), tabPriority.orElse(100));
    }

    private void extractAndPutDataTo(ExtensionTabData.Builder extensionTab, ExtensionDescriptive descriptive, ResultSet set) throws SQLException {
        boolean booleanValue = set.getBoolean("boolean_value");
        if (!set.wasNull()) {
            extensionTab.putBooleanData(new ExtensionBooleanData(descriptive, booleanValue));
            return;
        }
        double doubleValue = set.getDouble("double_value");
        if (!set.wasNull()) {
            extensionTab.putDoubleData(new ExtensionDoubleData(descriptive, doubleValue));
            return;
        }
        double percentageValue = set.getDouble("percentage_value");
        if (!set.wasNull()) {
            extensionTab.putPercentageData(new ExtensionDoubleData(descriptive, percentageValue));
            return;
        }
        long numberValue = set.getLong("long_value");
        if (!set.wasNull()) {
            FormatType formatType = FormatType.getByName(set.getString("format_type")).orElse(FormatType.NONE);
            extensionTab.putNumberData(new ExtensionNumberData(descriptive, formatType, numberValue));
            return;
        }
        String stringValue = set.getString("string_value");
        if (stringValue != null) {
            boolean isPlayerName = set.getBoolean("is_player_name");
            extensionTab.putStringData(new ExtensionStringData(descriptive, isPlayerName, stringValue));
        }
    }

    private ExtensionDescriptive extractDescriptive(ResultSet set) throws SQLException {
        String name = set.getString("provider_name");
        String text = set.getString("text");
        String description = set.getString("description");
        int priority = set.getInt("provider_priority");
        String iconName = set.getString("provider_icon_name");
        Family family = Family.getByName(set.getString("provider_icon_family")).orElse(Family.SOLID);
        Color color = Color.getByName(set.getString("provider_icon_color")).orElse(Color.NONE);
        Icon icon = new Icon(family, iconName, color);
        return new ExtensionDescriptive(name, text, description, icon, priority);
    }

    private Icon extractTabIcon(ResultSet set) throws SQLException {
        Optional<String> iconName = Optional.ofNullable(set.getString("tab_icon_name"));
        if (iconName.isPresent()) {
            Family iconFamily = Family.getByName(set.getString("tab_icon_family")).orElse(Family.SOLID);
            Color iconColor = Color.getByName(set.getString("tab_icon_color")).orElse(Color.NONE);
            return new Icon(iconFamily, iconName.get(), iconColor);
        }
        return TabInformation.defaultIcon();
    }
}

