/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionStringData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.extension.implementation.storage.queries.QueriedTabData;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ExtensionPlayerGroupsQuery
implements Query<Map<Integer, ExtensionData.Builder>> {
    private final UUID playerUUID;

    public ExtensionPlayerGroupsQuery(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Override
    public Map<Integer, ExtensionData.Builder> executeQuery(SQLDB db) {
        return db.query(this.fetchGroupsByPluginID());
    }

    private Query<Map<Integer, ExtensionData.Builder>> fetchGroupsByPluginID() {
        String sql = "SELECT v1.group_name as group_name,p1.plugin_id as plugin_id,p1.name as provider_name,p1.text as text,t1.name as tab_name,t1.tab_priority as tab_priority,t1.element_order as element_order,i1.name as provider_icon_name,i1.family as provider_icon_family,i1.color as provider_icon_color,i2.name as tab_icon_name,i2.family as tab_icon_family,i2.color as tab_icon_color FROM plan_extension_groups v1 JOIN plan_extension_providers p1 on p1.id=v1.provider_id LEFT JOIN plan_extension_tabs t1 on t1.id=p1.tab_id LEFT JOIN plan_extension_icons i1 on i1.id=p1.icon_id LEFT JOIN plan_extension_icons i2 on i2.id=p1.icon_id WHERE uuid=? AND p1.hidden=? ORDER BY group_name ASC";
        return new QueryStatement<Map<Integer, ExtensionData.Builder>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, ExtensionPlayerGroupsQuery.this.playerUUID.toString());
                statement.setBoolean(2, false);
            }

            @Override
            public Map<Integer, ExtensionData.Builder> processResults(ResultSet set) throws SQLException {
                return ExtensionPlayerGroupsQuery.this.extractTabDataByPluginID(set).toExtensionDataByPluginID();
            }
        };
    }

    private QueriedTabData extractTabDataByPluginID(ResultSet set) throws SQLException {
        QueriedTabData tabData = new QueriedTabData();
        while (set.next()) {
            int pluginID = set.getInt("plugin_id");
            String tabName = Optional.ofNullable(set.getString("tab_name")).orElse("");
            ExtensionTabData.Builder extensionTab = tabData.getTab(pluginID, tabName, () -> this.extractTabInformation(tabName, set));
            ExtensionDescriptive extensionDescriptive = this.extractDescriptive(set);
            String groupName = set.getString("group_name");
            extensionTab.putGroupData(new ExtensionStringData(extensionDescriptive, false, groupName));
        }
        return tabData;
    }

    private TabInformation extractTabInformation(String tabName, ResultSet set) throws SQLException {
        Optional<Integer> tabPriority = Optional.of(set.getInt("tab_priority"));
        if (set.wasNull()) {
            tabPriority = Optional.empty();
        }
        Optional<ElementOrder[]> elementOrder = Optional.ofNullable(set.getString("element_order")).map(ElementOrder::deserialize);
        Icon tabIcon = this.extractTabIcon(set);
        return new TabInformation(tabName, tabIcon, elementOrder.orElse(ElementOrder.values()), tabPriority.orElse(100));
    }

    private ExtensionDescriptive extractDescriptive(ResultSet set) throws SQLException {
        String name = set.getString("provider_name");
        String text = set.getString("text");
        String iconName = set.getString("provider_icon_name");
        Family family = Family.getByName(set.getString("provider_icon_family")).orElse(Family.SOLID);
        Color color = Color.getByName(set.getString("provider_icon_color")).orElse(Color.NONE);
        Icon icon = new Icon(family, iconName, color);
        return new ExtensionDescriptive(name, text, null, icon, 0);
    }

    private Icon extractTabIcon(ResultSet set) throws SQLException {
        Optional<String> iconName = Optional.ofNullable(set.getString("tab_icon_name"));
        if (iconName.isPresent()) {
            Family iconFamily = Family.getByName(set.getString("tab_icon_family")).orElse(Family.SOLID);
            Color iconColor = Color.getByName(set.getString("tab_icon_color")).orElse(Color.NONE);
            return new Icon(iconFamily, iconName.get(), iconColor);
        }
        return TabInformation.defaultIcon();
    }
}

