/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.storage.queries.QueriedTables;
import com.djrapitops.plan.extension.table.Table;
import com.djrapitops.plan.extension.table.TableAccessor;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ExtensionPlayerTablesQuery
implements Query<Map<Integer, ExtensionData.Builder>> {
    private final UUID playerUUID;

    public ExtensionPlayerTablesQuery(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Override
    public Map<Integer, ExtensionData.Builder> executeQuery(SQLDB db) {
        QueriedTables tablesWithValues = db.query(this.placeValuesToTables(db.query(this.queryTableProviders())));
        return tablesWithValues.toQueriedTabs().toExtensionDataByPluginID();
    }

    private Query<QueriedTables> placeValuesToTables(final QueriedTables tables) {
        String selectTableValues = "SELECT plugin_id,table_id,col_1_value,col_2_value,col_3_value,col_4_value FROM plan_extension_user_table_values JOIN plan_extension_tables on plan_extension_tables.id=plan_extension_user_table_values.table_id WHERE uuid=?";
        return new QueryStatement<QueriedTables>(selectTableValues, 10000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, ExtensionPlayerTablesQuery.this.playerUUID.toString());
            }

            @Override
            public QueriedTables processResults(ResultSet set) throws SQLException {
                while (set.next()) {
                    tables.addRow(set.getInt("plugin_id"), set.getInt("table_id"), ExtensionPlayerTablesQuery.this.extractTableRow(set));
                }
                return tables;
            }
        };
    }

    private Object[] extractTableRow(ResultSet set) throws SQLException {
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 1; i <= 4; ++i) {
            String columnName = "col_" + i + "_value";
            String value = set.getString(columnName);
            if (value == null) {
                return row.toArray(new Object[0]);
            }
            row.add(value);
        }
        return row.toArray(new Object[0]);
    }

    private Query<QueriedTables> queryTableProviders() {
        String selectTables = "SELECT p1.id as table_id,p1.plugin_id as plugin_id,p1.name as table_name,p1.color as table_color,col_1_name,col_2_name,col_3_name,col_4_name,t1.name as tab_name,t1.tab_priority as tab_priority,t1.element_order as element_order,i1.name as i1_name,i1.family as i1_family,i1.color as i1_color,i2.name as i2_name,i2.family as i2_family,i2.color as i2_color,i3.name as i3_name,i3.family as i3_family,i3.color as i3_color,i4.name as i4_name,i4.family as i4_family,i4.color as i4_color,i6.name as tab_icon_name,i6.family as tab_icon_family,i6.color as tab_icon_color FROM plan_extension_tables p1 JOIN plan_extension_user_table_values v1 on v1.table_id=p1.id LEFT JOIN plan_extension_tabs t1 on t1.id=p1.tab_id LEFT JOIN plan_extension_icons i1 on i1.id=p1.icon_1_id LEFT JOIN plan_extension_icons i2 on i2.id=p1.icon_2_id LEFT JOIN plan_extension_icons i3 on i3.id=p1.icon_3_id LEFT JOIN plan_extension_icons i4 on i4.id=p1.icon_4_id LEFT JOIN plan_extension_icons i6 on i6.id=t1.icon_id WHERE v1.uuid=?";
        return new QueryStatement<QueriedTables>(selectTables, 100){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, ExtensionPlayerTablesQuery.this.playerUUID.toString());
            }

            @Override
            public QueriedTables processResults(ResultSet set) throws SQLException {
                QueriedTables tables = new QueriedTables();
                while (set.next()) {
                    tables.put(set.getInt("plugin_id"), set.getInt("table_id"), ExtensionPlayerTablesQuery.this.extractTable(set));
                }
                return tables;
            }
        };
    }

    private Table.Factory extractTable(ResultSet set) throws SQLException {
        Table.Factory table = Table.builder();
        this.extractColumns(set, table);
        TableAccessor.setColor(table, Color.getByName(set.getString("table_color")).orElse(Color.NONE));
        TableAccessor.setTableName(table, set.getString("table_name"));
        TableAccessor.setTabName(table, Optional.ofNullable(set.getString("tab_name")).orElse(""));
        TableAccessor.setTabPriority(table, Optional.of(set.getInt("tab_priority")).orElse(100));
        TableAccessor.setTabOrder(table, Optional.ofNullable(set.getString("element_order")).map(ElementOrder::deserialize).orElse(ElementOrder.values()));
        TableAccessor.setTabIcon(table, this.extractIcon(set, "tab_icon"));
        return table;
    }

    private void extractColumns(ResultSet set, Table.Factory table) throws SQLException {
        String col4;
        String col3;
        String col2;
        String col1 = set.getString("col_1_name");
        if (col1 != null) {
            table.columnOne(col1, this.extractIcon(set, "i1"));
        }
        if ((col2 = set.getString("col_2_name")) != null) {
            table.columnTwo(col2, this.extractIcon(set, "i2"));
        }
        if ((col3 = set.getString("col_3_name")) != null) {
            table.columnThree(col3, this.extractIcon(set, "i3"));
        }
        if ((col4 = set.getString("col_4_name")) != null) {
            table.columnFour(col4, this.extractIcon(set, "i4"));
        }
    }

    private Icon extractIcon(ResultSet set, String iconColumnName) throws SQLException {
        String iconName = set.getString(iconColumnName + "_name");
        if (iconName == null) {
            return null;
        }
        return new Icon(Family.getByName(set.getString(iconColumnName + "_family")).orElse(Family.SOLID), iconName, Color.getByName(set.getString(iconColumnName + "_color")).orElse(Color.NONE));
    }
}

