/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Family;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.results.ExtensionBooleanData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionDoubleData;
import com.djrapitops.plan.extension.implementation.results.ExtensionNumberData;
import com.djrapitops.plan.extension.implementation.results.ExtensionStringData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.storage.database.SQLDB;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class ExtensionServerPlayerDataTableQuery
implements Query<Map<UUID, ExtensionTabData>> {
    private final UUID serverUUID;
    private final int xMostRecentPlayers;

    public ExtensionServerPlayerDataTableQuery(UUID serverUUID, int xMostRecentPlayers) {
        this.serverUUID = serverUUID;
        this.xMostRecentPlayers = xMostRecentPlayers;
    }

    @Override
    public Map<UUID, ExtensionTabData> executeQuery(SQLDB db) {
        return this.combine(db.query(this.fetchPlayerData()), db.query(this.fetchPlayerGroups()));
    }

    private Map<UUID, ExtensionTabData> combine(Map<UUID, ExtensionTabData> one, Map<UUID, ExtensionTabData> two) {
        for (Map.Entry<UUID, ExtensionTabData> entry : two.entrySet()) {
            UUID playerUUID = entry.getKey();
            ExtensionTabData data = entry.getValue();
            ExtensionTabData existingData = one.get(playerUUID);
            if (existingData != null) {
                existingData.combine(data);
            } else {
                existingData = data;
            }
            one.put(playerUUID, existingData);
        }
        return one;
    }

    private Query<Map<UUID, ExtensionTabData>> fetchPlayerData() {
        String selectLimitedNumberOfPlayerUUIDsByLastSeenDate = "SELECT plan_sessions.uuid,MAX(session_end) as last_seen FROM plan_sessions GROUP BY plan_sessions.uuid ORDER BY last_seen DESC LIMIT ?";
        String sql = "SELECT v1.uuid as uuid,v1.boolean_value as boolean_value,v1.double_value as double_value,v1.percentage_value as percentage_value,v1.long_value as long_value,v1.string_value as string_value,null as group_value,p1.name as provider_name,p1.text as text,p1.format_type as format_type,p1.player_name as is_player_name,i1.name as provider_icon_name,i1.family as provider_icon_family FROM plan_extension_user_values v1 JOIN (" + selectLimitedNumberOfPlayerUUIDsByLastSeenDate + ") as last_seen_q on last_seen_q.uuid=v1." + "uuid" + " JOIN " + "plan_extension_providers" + " p1 on p1." + "id" + "=v1." + "provider_id" + " JOIN " + "plan_extension_plugins" + " e1 on e1." + "id" + "=p1." + "plugin_id" + " LEFT JOIN " + "plan_extension_icons" + " i1 on i1." + "id" + "=p1." + "icon_id" + " WHERE " + "e1." + "server_uuid" + "=?" + " AND " + "p1." + "show_in_players_table" + "=?" + " AND " + "p1." + "player_name" + "=?";
        return new QueryStatement<Map<UUID, ExtensionTabData>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setInt(1, ExtensionServerPlayerDataTableQuery.this.xMostRecentPlayers);
                statement.setString(2, ExtensionServerPlayerDataTableQuery.this.serverUUID.toString());
                statement.setBoolean(3, true);
                statement.setBoolean(4, false);
            }

            @Override
            public Map<UUID, ExtensionTabData> processResults(ResultSet set) throws SQLException {
                return ExtensionServerPlayerDataTableQuery.this.extractDataByPlayer(set);
            }
        };
    }

    private Query<Map<UUID, ExtensionTabData>> fetchPlayerGroups() {
        String selectLimitedNumberOfPlayerUUIDsByLastSeenDate = "SELECT plan_sessions.uuid,MAX(session_end) as last_seen FROM plan_sessions GROUP BY plan_sessions.uuid ORDER BY last_seen DESC LIMIT ?";
        String sql = "SELECT v1.uuid as uuid,v1.group_name as group_value,p1.name as provider_name,p1.text as text,i1.name as provider_icon_name,i1.family as provider_icon_family FROM plan_extension_groups v1 JOIN (" + selectLimitedNumberOfPlayerUUIDsByLastSeenDate + ") as last_seen_q on last_seen_q.uuid=v1." + "uuid" + " JOIN " + "plan_extension_providers" + " p1 on p1." + "id" + "=v1." + "provider_id" + " JOIN " + "plan_extension_plugins" + " e1 on e1." + "id" + "=p1." + "plugin_id" + " LEFT JOIN " + "plan_extension_icons" + " i1 on i1." + "id" + "=p1." + "icon_id" + " WHERE " + "e1." + "server_uuid" + "=?";
        return new QueryStatement<Map<UUID, ExtensionTabData>>(sql, 1000){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setInt(1, ExtensionServerPlayerDataTableQuery.this.xMostRecentPlayers);
                statement.setString(2, ExtensionServerPlayerDataTableQuery.this.serverUUID.toString());
            }

            @Override
            public Map<UUID, ExtensionTabData> processResults(ResultSet set) throws SQLException {
                return ExtensionServerPlayerDataTableQuery.this.extractDataByPlayer(set);
            }
        };
    }

    private Map<UUID, ExtensionTabData> extractDataByPlayer(ResultSet set) throws SQLException {
        HashMap<UUID, ExtensionTabData.Builder> dataByPlayer = new HashMap<UUID, ExtensionTabData.Builder>();
        while (set.next()) {
            UUID playerUUID = UUID.fromString(set.getString("uuid"));
            ExtensionTabData.Builder data = dataByPlayer.getOrDefault(playerUUID, new ExtensionTabData.Builder(null));
            ExtensionDescriptive extensionDescriptive = this.extractDescriptive(set);
            this.extractAndPutDataTo(data, extensionDescriptive, set);
            dataByPlayer.put(playerUUID, data);
        }
        return dataByPlayer.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ExtensionTabData.Builder)entry.getValue()).build()));
    }

    private void extractAndPutDataTo(ExtensionTabData.Builder extensionTab, ExtensionDescriptive descriptive, ResultSet set) throws SQLException {
        String groupValue = set.getString("group_value");
        if (groupValue != null) {
            extensionTab.putGroupData(new ExtensionStringData(descriptive, false, groupValue));
            return;
        }
        boolean booleanValue = set.getBoolean("boolean_value");
        if (!set.wasNull()) {
            extensionTab.putBooleanData(new ExtensionBooleanData(descriptive, booleanValue));
            return;
        }
        double doubleValue = set.getDouble("double_value");
        if (!set.wasNull()) {
            extensionTab.putDoubleData(new ExtensionDoubleData(descriptive, doubleValue));
            return;
        }
        double percentageValue = set.getDouble("percentage_value");
        if (!set.wasNull()) {
            extensionTab.putPercentageData(new ExtensionDoubleData(descriptive, percentageValue));
            return;
        }
        long numberValue = set.getLong("long_value");
        if (!set.wasNull()) {
            FormatType formatType = FormatType.getByName(set.getString("format_type")).orElse(FormatType.NONE);
            extensionTab.putNumberData(new ExtensionNumberData(descriptive, formatType, numberValue));
            return;
        }
        String stringValue = set.getString("string_value");
        if (stringValue != null) {
            boolean isPlayerName = false;
            extensionTab.putStringData(new ExtensionStringData(descriptive, isPlayerName, stringValue));
        }
    }

    private ExtensionDescriptive extractDescriptive(ResultSet set) throws SQLException {
        String name = set.getString("provider_name");
        String text = set.getString("text");
        String iconName = set.getString("provider_icon_name");
        Family family = Family.getByName(set.getString("provider_icon_family")).orElse(Family.SOLID);
        Icon icon = new Icon(family, iconName, Color.NONE);
        return new ExtensionDescriptive(name, text, null, icon, 0);
    }
}

