/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.utilities.java.Maps;
import com.djrapitops.plan.utilities.java.ThrowingSupplier;
import java.util.HashMap;
import java.util.Map;

public class QueriedTabData {
    private final Map<Integer, Map<String, ExtensionTabData.Builder>> byPluginID = new HashMap<Integer, Map<String, ExtensionTabData.Builder>>();

    public <K extends Throwable> ExtensionTabData.Builder getTab(int pluginID, String tabName, ThrowingSupplier<TabInformation, K> newDefault) throws K {
        Map byTabName = this.byPluginID.computeIfAbsent(pluginID, Maps::create);
        ExtensionTabData.Builder tab = (ExtensionTabData.Builder)byTabName.get(tabName);
        if (tab == null) {
            tab = new ExtensionTabData.Builder(newDefault.get());
        }
        byTabName.put(tabName, tab);
        return tab;
    }

    public Map<Integer, ExtensionData.Builder> toExtensionDataByPluginID() {
        HashMap<Integer, ExtensionData.Builder> dataByPluginID = new HashMap<Integer, ExtensionData.Builder>();
        for (Map.Entry<Integer, Map<String, ExtensionTabData.Builder>> entry : this.byPluginID.entrySet()) {
            Integer pluginID = entry.getKey();
            ExtensionData.Builder data = (ExtensionData.Builder)dataByPluginID.get(pluginID);
            if (data == null) {
                data = new ExtensionData.Builder(pluginID);
            }
            for (ExtensionTabData.Builder tabData : entry.getValue().values()) {
                data.addTab(tabData.build());
            }
            dataByPluginID.put(pluginID, data);
        }
        return dataByPluginID;
    }
}

