/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.queries;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTableData;
import com.djrapitops.plan.extension.implementation.storage.queries.QueriedTabData;
import com.djrapitops.plan.extension.table.Table;
import com.djrapitops.plan.extension.table.TableAccessor;
import com.djrapitops.plan.utilities.java.Maps;
import java.util.HashMap;
import java.util.Map;

public class QueriedTables {
    private final Map<Integer, Map<Integer, Table.Factory>> byPluginID = new HashMap<Integer, Map<Integer, Table.Factory>>();

    public boolean contains(int pluginID, int tableID) {
        Map<Integer, Table.Factory> byTableID = this.byPluginID.get(pluginID);
        return byTableID != null && byTableID.containsKey(tableID);
    }

    public void put(int pluginID, int tableID, Table.Factory table) {
        Map byTableID = this.byPluginID.computeIfAbsent(pluginID, Maps::create);
        byTableID.put(tableID, table);
    }

    public void addRow(int pluginID, int tableID, Object ... row) {
        if (row.length <= 0) {
            return;
        }
        Map<Integer, Table.Factory> byTableID = this.byPluginID.get(pluginID);
        if (byTableID == null) {
            return;
        }
        Table.Factory table = byTableID.get(tableID);
        if (table == null) {
            return;
        }
        table.addRow(row);
    }

    public QueriedTabData toQueriedTabs() {
        QueriedTabData tabData = new QueriedTabData();
        for (Map.Entry<Integer, Map<Integer, Table.Factory>> entry : this.byPluginID.entrySet()) {
            Integer pluginID = entry.getKey();
            for (Table.Factory table : entry.getValue().values()) {
                String tableName = TableAccessor.getTableName(table);
                Color tableColor = TableAccessor.getColor(table);
                String tabName = TableAccessor.getTabName(table);
                ExtensionTabData.Builder tab = tabData.getTab(pluginID, tabName, () -> this.extractTabInformation(table));
                tab.putTableData(new ExtensionTableData(tableName, table.build(), tableColor));
            }
        }
        return tabData;
    }

    private TabInformation extractTabInformation(Table.Factory table) {
        String tabName = TableAccessor.getTabName(table);
        int tabPriority = TableAccessor.getTabPriority(table);
        ElementOrder[] tabOrder = TableAccessor.getTabOrder(table);
        Icon tabIcon = TableAccessor.getTabIcon(table);
        return new TabInformation(tabName, tabIcon, tabOrder, tabPriority);
    }
}

