/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions;

import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.storage.database.queries.HasMoreThanZeroQueryStatement;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionIconTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class StoreIconTransaction
extends ThrowawayTransaction {
    private final Icon icon;

    public StoreIconTransaction(Icon icon) {
        this.icon = icon;
    }

    @Override
    protected void performOperations() {
        if (!this.query(this.isIconStored()).booleanValue()) {
            this.execute(this.insertIcon());
        }
    }

    private Executable insertIcon() {
        String sql = "INSERT INTO plan_extension_icons(name,family,color) VALUES (?,?,?)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ExtensionIconTable.set3IconValuesToStatement(statement, StoreIconTransaction.this.icon);
            }
        };
    }

    private Query<Boolean> isIconStored() {
        String sql = "SELECT COUNT(1) as c FROM plan_extension_icons WHERE name=? AND family=? AND color=?";
        return new HasMoreThanZeroQueryStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ExtensionIconTable.set3IconValuesToStatement(statement, StoreIconTransaction.this.icon);
            }
        };
    }
}

