/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions;

import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionIconTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class StorePluginTransaction
extends ThrowawayTransaction {
    private final String pluginName;
    private final long time;
    private final UUID serverUUID;
    private final Icon icon;

    public StorePluginTransaction(String pluginName, long time, UUID serverUUID, Icon icon) {
        this.pluginName = pluginName;
        this.time = time;
        this.serverUUID = serverUUID;
        this.icon = icon;
    }

    @Override
    protected void performOperations() {
        this.execute(this.storePlugin());
    }

    private Executable storePlugin() {
        return connection -> {
            if (!this.updatePlugin().execute(connection)) {
                return this.insertPlugin().execute(connection);
            }
            return false;
        };
    }

    private Executable updatePlugin() {
        String sql = "UPDATE plan_extension_plugins SET last_updated=?,icon_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1) WHERE name=? AND server_uuid=?";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, StorePluginTransaction.this.time);
                ExtensionIconTable.set3IconValuesToStatement(statement, 2, StorePluginTransaction.this.icon);
                statement.setString(5, StorePluginTransaction.this.pluginName);
                statement.setString(6, StorePluginTransaction.this.serverUUID.toString());
            }
        };
    }

    private Executable insertPlugin() {
        String sql = "INSERT INTO plan_extension_plugins(name,last_updated,server_uuid,icon_id) VALUES (?,?,?,(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1))";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StorePluginTransaction.this.pluginName);
                statement.setLong(2, StorePluginTransaction.this.time);
                statement.setString(3, StorePluginTransaction.this.serverUUID.toString());
                ExtensionIconTable.set3IconValuesToStatement(statement, 4, StorePluginTransaction.this.icon);
            }
        };
    }
}

