/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionIconTable;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionPluginTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class StoreTabInformationTransaction
extends ThrowawayTransaction {
    private final String pluginName;
    private final UUID serverUUID;
    private final TabInformation tabInformation;

    public StoreTabInformationTransaction(String pluginName, UUID serverUUID, TabInformation tabInformation) {
        this.pluginName = pluginName;
        this.serverUUID = serverUUID;
        this.tabInformation = tabInformation;
    }

    @Override
    protected void performOperations() {
        this.execute(this.storeTab());
    }

    private Executable storeTab() {
        return connection -> {
            if (!this.updateTab().execute(connection)) {
                return this.insertTab().execute(connection);
            }
            return false;
        };
    }

    private Executable updateTab() {
        String sql = "UPDATE plan_extension_tabs SET tab_priority=?,element_order=?,icon_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1) WHERE plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) AND name=?";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setInt(1, StoreTabInformationTransaction.this.tabInformation.getTabPriority());
                statement.setString(2, ElementOrder.serialize(StoreTabInformationTransaction.this.tabInformation.getTabElementOrder().orElse(ElementOrder.values())));
                ExtensionIconTable.set3IconValuesToStatement(statement, 3, StoreTabInformationTransaction.this.tabInformation.getTabIcon());
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 6, StoreTabInformationTransaction.this.pluginName, StoreTabInformationTransaction.this.serverUUID);
                statement.setString(8, StoreTabInformationTransaction.this.tabInformation.getTabName());
            }
        };
    }

    private Executable insertTab() {
        String sql = "INSERT INTO plan_extension_tabs(name,element_order,tab_priority,icon_id,plugin_id) VALUES (?,?,?,(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1))";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StoreTabInformationTransaction.this.tabInformation.getTabName());
                statement.setString(2, ElementOrder.serialize(StoreTabInformationTransaction.this.tabInformation.getTabElementOrder().orElse(ElementOrder.values())));
                statement.setInt(3, StoreTabInformationTransaction.this.tabInformation.getTabPriority());
                ExtensionIconTable.set3IconValuesToStatement(statement, 4, StoreTabInformationTransaction.this.tabInformation.getTabIcon());
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 7, StoreTabInformationTransaction.this.pluginName, StoreTabInformationTransaction.this.serverUUID);
            }
        };
    }
}

