/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.providers;

import com.djrapitops.plan.extension.implementation.ProviderInformation;
import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.storage.database.sql.building.Sql;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionIconTable;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionPluginTable;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionTabTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class StoreProviderTransaction
extends ThrowawayTransaction {
    private final DataProvider<?> provider;
    private final UUID serverUUID;

    public StoreProviderTransaction(DataProvider<?> provider, UUID serverUUID) {
        this.provider = provider;
        this.serverUUID = serverUUID;
    }

    @Override
    protected void performOperations() {
        this.execute(this.storeProvider());
    }

    private Executable storeProvider() {
        return connection -> {
            if (!this.updateProvider().execute(connection)) {
                return this.insertProvider().execute(connection);
            }
            return false;
        };
    }

    private Executable updateProvider() {
        String sql = "UPDATE plan_extension_providers SET text=?,description=?,priority=?,condition_name=?,icon_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),tab_id=(SELECT id FROM plan_extension_tabs WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1),show_in_players_table=?,hidden=?,provided_condition=?,format_type=?,player_name=? WHERE plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) AND name=?";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ProviderInformation info = StoreProviderTransaction.this.provider.getProviderInformation();
                statement.setString(1, info.getText());
                Sql.setStringOrNull(statement, 2, info.getDescription().orElse(null));
                statement.setInt(3, info.getPriority());
                Sql.setStringOrNull(statement, 4, info.getCondition().orElse(null));
                ExtensionIconTable.set3IconValuesToStatement(statement, 5, info.getIcon());
                ExtensionTabTable.set3TabValuesToStatement(statement, 8, info.getTab().orElse(null), info.getPluginName(), StoreProviderTransaction.this.serverUUID);
                statement.setBoolean(11, info.isShownInPlayersTable());
                statement.setBoolean(12, info.isHidden());
                Sql.setStringOrNull(statement, 13, info.getProvidedCondition());
                Sql.setStringOrNull(statement, 14, info.getFormatType().map(Enum::name).orElse(null));
                statement.setBoolean(15, info.isPlayerName());
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 16, info.getPluginName(), StoreProviderTransaction.this.serverUUID);
                statement.setString(18, info.getName());
            }
        };
    }

    private Executable insertProvider() {
        String sql = "INSERT INTO plan_extension_providers(name,text,description,priority,condition_name,show_in_players_table,hidden,provided_condition,format_type,player_name,tab_id,icon_id,plugin_id) VALUES (?,?,?,?,?,?,?,?,?,?,(SELECT id FROM plan_extension_tabs WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1),(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1))";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ProviderInformation info = StoreProviderTransaction.this.provider.getProviderInformation();
                statement.setString(1, info.getName());
                statement.setString(2, info.getText());
                Sql.setStringOrNull(statement, 3, info.getDescription().orElse(null));
                statement.setInt(4, info.getPriority());
                Sql.setStringOrNull(statement, 5, info.getCondition().orElse(null));
                statement.setBoolean(6, info.isShownInPlayersTable());
                statement.setBoolean(7, info.isHidden());
                Sql.setStringOrNull(statement, 8, info.getProvidedCondition());
                Sql.setStringOrNull(statement, 9, info.getFormatType().map(Enum::name).orElse(null));
                statement.setBoolean(10, info.isPlayerName());
                ExtensionTabTable.set3TabValuesToStatement(statement, 11, info.getTab().orElse(null), info.getPluginName(), StoreProviderTransaction.this.serverUUID);
                ExtensionIconTable.set3IconValuesToStatement(statement, 14, info.getIcon());
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 17, info.getPluginName(), StoreProviderTransaction.this.serverUUID);
            }
        };
    }
}

