/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.providers;

import com.djrapitops.plan.extension.icon.Icon;
import com.djrapitops.plan.extension.implementation.ProviderInformation;
import com.djrapitops.plan.extension.table.Table;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionIconTable;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionPluginTable;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionTabTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class StoreTableProviderTransaction
extends ThrowawayTransaction {
    private final UUID serverUUID;
    private final ProviderInformation information;
    private final Table table;

    public StoreTableProviderTransaction(UUID serverUUID, ProviderInformation information, Table table) {
        this.information = information;
        this.table = table;
        this.serverUUID = serverUUID;
    }

    @Override
    protected void performOperations() {
        this.execute(this.storeProvider());
    }

    private Executable storeProvider() {
        return connection -> {
            if (!this.updateProvider().execute(connection)) {
                return this.insertProvider().execute(connection);
            }
            return false;
        };
    }

    private Executable updateProvider() {
        final String[] columns = this.table.getColumns();
        final Icon[] icons = this.table.getIcons();
        String sql = "UPDATE plan_extension_tables SET color=?,col_1_name=?,col_2_name=?,col_3_name=?,col_4_name=?,col_5_name=?,condition_name=?,tab_id=(SELECT id FROM plan_extension_tabs WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1),icon_1_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),icon_2_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),icon_3_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),icon_4_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),icon_5_id=(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1) WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StoreTableProviderTransaction.this.information.getTableColor().name());
                StoreTableProviderTransaction.this.setStringOrNull(statement, 2, columns[0]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 3, columns[1]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 4, columns[2]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 5, columns[3]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 6, columns[4]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 7, StoreTableProviderTransaction.this.information.getCondition().orElse(null));
                ExtensionTabTable.set3TabValuesToStatement(statement, 8, StoreTableProviderTransaction.this.information.getTab().orElse("No Tab"), StoreTableProviderTransaction.this.information.getPluginName(), StoreTableProviderTransaction.this.serverUUID);
                ExtensionIconTable.set3IconValuesToStatement(statement, 11, icons[0]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 14, icons[1]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 17, icons[2]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 20, icons[3]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 23, icons[4]);
                statement.setString(26, StoreTableProviderTransaction.this.information.getName());
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 27, StoreTableProviderTransaction.this.information.getPluginName(), StoreTableProviderTransaction.this.serverUUID);
            }
        };
    }

    private Executable insertProvider() {
        final String[] columns = this.table.getColumns();
        final Icon[] icons = this.table.getIcons();
        String sql = "INSERT INTO plan_extension_tables(name,color,col_1_name,col_2_name,col_3_name,col_4_name,col_5_name,condition_name,tab_id,plugin_id,icon_1_id,icon_2_id,icon_3_id,icon_4_id,icon_5_id) VALUES (?,?,?,?,?,?,?,?,(SELECT id FROM plan_extension_tabs WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1),(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1),(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1),(SELECT id FROM plan_extension_icons WHERE name=? AND family=? AND color=? LIMIT 1))";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StoreTableProviderTransaction.this.information.getName());
                statement.setString(2, StoreTableProviderTransaction.this.information.getTableColor().name());
                StoreTableProviderTransaction.this.setStringOrNull(statement, 3, columns[0]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 4, columns[1]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 5, columns[2]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 6, columns[3]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 7, columns[4]);
                StoreTableProviderTransaction.this.setStringOrNull(statement, 8, StoreTableProviderTransaction.this.information.getCondition().orElse(null));
                ExtensionTabTable.set3TabValuesToStatement(statement, 9, StoreTableProviderTransaction.this.information.getTab().orElse("No Tab"), StoreTableProviderTransaction.this.information.getPluginName(), StoreTableProviderTransaction.this.serverUUID);
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 12, StoreTableProviderTransaction.this.information.getPluginName(), StoreTableProviderTransaction.this.serverUUID);
                ExtensionIconTable.set3IconValuesToStatement(statement, 14, icons[0]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 17, icons[1]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 20, icons[2]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 23, icons[3]);
                ExtensionIconTable.set3IconValuesToStatement(statement, 26, icons[4]);
            }
        };
    }

    private void setStringOrNull(PreparedStatement statement, int index, String value) throws SQLException {
        if (value != null) {
            statement.setString(index, value);
        } else {
            statement.setNull(index, 12);
        }
    }
}

