/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.results;

import com.djrapitops.plan.storage.database.sql.tables.ExtensionPluginTable;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionProviderTable;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionTableProviderTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.UUID;

public class RemoveInvalidResultsTransaction
extends ThrowawayTransaction {
    private final String pluginName;
    private final UUID serverUUID;
    private final Collection<String> invalidatedMethods;

    public RemoveInvalidResultsTransaction(String pluginName, UUID serverUUID, Collection<String> invalidatedMethods) {
        this.pluginName = pluginName;
        this.serverUUID = serverUUID;
        this.invalidatedMethods = invalidatedMethods;
    }

    @Override
    protected void performOperations() {
        for (String invalidatedMethod : this.invalidatedMethods) {
            this.execute(this.deleteInvalidPlayerMethodResults(invalidatedMethod));
            this.execute(this.deleteInvalidServerMethodResults(invalidatedMethod));
            this.execute(this.deleteInvalidMethodProvider(invalidatedMethod));
            this.execute(this.deleteInvalidPlayerTableResults(invalidatedMethod));
            this.execute(this.deleteInvalidServerTableResults(invalidatedMethod));
            this.execute(this.deleteInvalidTableProvider(invalidatedMethod));
        }
    }

    private Executable deleteInvalidPlayerMethodResults(final String invalidMethod) {
        String sql = "DELETE FROM plan_extension_user_values WHERE provider_id=(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 1, invalidMethod, RemoveInvalidResultsTransaction.this.pluginName, RemoveInvalidResultsTransaction.this.serverUUID);
            }
        };
    }

    private Executable deleteInvalidServerMethodResults(final String invalidMethod) {
        String sql = "DELETE FROM plan_extension_server_values WHERE provider_id=(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 1, invalidMethod, RemoveInvalidResultsTransaction.this.pluginName, RemoveInvalidResultsTransaction.this.serverUUID);
            }
        };
    }

    private Executable deleteInvalidPlayerTableResults(final String invalidMethod) {
        String sql = "DELETE FROM plan_extension_user_table_values WHERE table_id=(SELECT id FROM plan_extension_tables WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ExtensionTableProviderTable.set3PluginValuesToStatement(statement, 1, invalidMethod, RemoveInvalidResultsTransaction.this.pluginName, RemoveInvalidResultsTransaction.this.serverUUID);
            }
        };
    }

    private Executable deleteInvalidServerTableResults(final String invalidMethod) {
        String sql = "DELETE FROM plan_extension_server_table_values WHERE table_id=(SELECT id FROM plan_extension_tables WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ExtensionTableProviderTable.set3PluginValuesToStatement(statement, 1, invalidMethod, RemoveInvalidResultsTransaction.this.pluginName, RemoveInvalidResultsTransaction.this.serverUUID);
            }
        };
    }

    private Executable deleteInvalidMethodProvider(final String invalidMethod) {
        String sql = "DELETE FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, invalidMethod);
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 2, RemoveInvalidResultsTransaction.this.pluginName, RemoveInvalidResultsTransaction.this.serverUUID);
            }
        };
    }

    private Executable deleteInvalidTableProvider(final String invalidMethod) {
        String sql = "DELETE FROM plan_extension_tables WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, invalidMethod);
                ExtensionPluginTable.set2PluginValuesToStatement(statement, 2, RemoveInvalidResultsTransaction.this.pluginName, RemoveInvalidResultsTransaction.this.serverUUID);
            }
        };
    }
}

