/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.results;

import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class RemoveUnsatisfiedConditionalPlayerResultsTransaction
extends ThrowawayTransaction {
    private final String providerTable;
    private final String playerValueTable;
    private final String playerTableValueTable;
    private final String tableTable;
    private final String groupTable;

    public RemoveUnsatisfiedConditionalPlayerResultsTransaction() {
        this.providerTable = "plan_extension_providers";
        this.playerValueTable = "plan_extension_user_values";
        this.tableTable = "plan_extension_tables";
        this.groupTable = "plan_extension_groups";
        this.playerTableValueTable = "plan_extension_user_table_values";
    }

    @Override
    protected void performOperations() {
        String selectSatisfiedConditions = this.getSatisfiedConditionsSQL();
        this.execute(this.deleteUnsatisfiedValues(selectSatisfiedConditions));
        this.execute(this.deleteUnsatisfiedGroupValues(selectSatisfiedConditions));
        this.execute(this.deleteUnsatisfiedTableValues(selectSatisfiedConditions));
    }

    private String getSatisfiedConditionsSQL() {
        String reversedCondition = this.dbType == DBType.SQLITE ? "'not_' || provided_condition" : "CONCAT('not_',provided_condition)";
        String selectSatisfiedPositiveConditions = "SELECT provided_condition,plugin_id,uuid FROM " + this.providerTable + " JOIN " + this.playerValueTable + " on " + this.providerTable + '.' + "id" + "=" + "provider_id" + " WHERE " + "boolean_value" + "=?" + " AND " + "provided_condition" + " IS NOT NULL";
        String selectSatisfiedNegativeConditions = "SELECT " + reversedCondition + " as " + "provided_condition" + ',' + "plugin_id" + ',' + "uuid" + " FROM " + this.providerTable + " JOIN " + this.playerValueTable + " on " + this.providerTable + '.' + "id" + "=" + "provider_id" + " WHERE " + "boolean_value" + "=?" + " AND " + "provided_condition" + " IS NOT NULL";
        return '(' + selectSatisfiedPositiveConditions + " UNION " + selectSatisfiedNegativeConditions + ") q1";
    }

    private Executable deleteUnsatisfiedValues(String selectSatisfiedConditions) {
        String selectUnsatisfiedValueIDs = "SELECT " + this.playerValueTable + '.' + "id" + " FROM " + this.providerTable + " JOIN " + this.playerValueTable + " on " + this.providerTable + '.' + "id" + "=" + "provider_id" + " LEFT JOIN " + selectSatisfiedConditions + " on (" + this.playerValueTable + '.' + "uuid" + "=q1." + "uuid" + " AND " + "condition_name" + "=q1." + "provided_condition" + " AND " + this.providerTable + '.' + "plugin_id" + "=q1." + "plugin_id" + ')' + " WHERE " + "q1." + "provided_condition" + " IS NULL" + " AND " + "condition_name" + " IS NOT NULL";
        String sql = "DELETE FROM " + this.playerValueTable + " WHERE " + "id" + " IN (" + "SELECT " + "id" + " FROM " + '(' + selectUnsatisfiedValueIDs + ") as ids)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
                statement.setBoolean(2, false);
            }
        };
    }

    private Executable deleteUnsatisfiedTableValues(String selectSatisfiedConditions) {
        String selectUnsatisfiedValueIDs = "SELECT id FROM " + this.tableTable + " LEFT JOIN " + selectSatisfiedConditions + " on (" + this.tableTable + '.' + "condition_name" + "=q1." + "provided_condition" + " AND " + this.tableTable + '.' + "plugin_id" + "=q1." + "plugin_id" + ')' + " WHERE " + "q1." + "provided_condition" + " IS NULL" + " AND " + "condition_name" + " IS NOT NULL";
        String deleteValuesSQL = "DELETE FROM " + this.playerTableValueTable + " WHERE " + "table_id" + " IN (" + "SELECT " + "id" + " FROM " + '(' + selectUnsatisfiedValueIDs + ") as ids)";
        return new ExecStatement(deleteValuesSQL){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
                statement.setBoolean(2, false);
            }
        };
    }

    private Executable deleteUnsatisfiedGroupValues(String selectSatisfiedConditions) {
        String selectUnsatisfiedIDs = "SELECT " + this.groupTable + '.' + "id" + " FROM " + this.groupTable + " JOIN " + this.providerTable + " on " + this.providerTable + '.' + "id" + '=' + this.groupTable + '.' + "provider_id" + " LEFT JOIN " + selectSatisfiedConditions + " on (" + this.groupTable + '.' + "uuid" + "=q1." + "uuid" + " AND " + "condition_name" + "=q1." + "provided_condition" + " AND " + this.providerTable + '.' + "plugin_id" + "=q1." + "plugin_id" + ')' + " WHERE " + "q1." + "provided_condition" + " IS NULL" + " AND " + "condition_name" + " IS NOT NULL";
        String deleteValuesSQL = "DELETE FROM " + this.groupTable + " WHERE " + "id" + " IN (" + "SELECT " + "id" + " FROM " + '(' + selectUnsatisfiedIDs + ") as ids)";
        return new ExecStatement(deleteValuesSQL){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
                statement.setBoolean(2, false);
            }
        };
    }
}

