/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.results;

import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class RemoveUnsatisfiedConditionalServerResultsTransaction
extends ThrowawayTransaction {
    private final String providerTable;
    private final String serverValueTable;
    private final String serverTableValueTable;
    private final String tableTable;

    public RemoveUnsatisfiedConditionalServerResultsTransaction() {
        this.providerTable = "plan_extension_providers";
        this.serverValueTable = "plan_extension_server_values";
        this.tableTable = "plan_extension_tables";
        this.serverTableValueTable = "plan_extension_server_table_values";
    }

    @Override
    protected void performOperations() {
        String selectSatisfiedConditions = this.getSatisfiedConditionsSQL();
        this.execute(this.deleteUnsatisfiedValues(selectSatisfiedConditions));
        this.execute(this.deleteUnsatisfiedTableValues(selectSatisfiedConditions));
    }

    private Executable deleteUnsatisfiedValues(String selectSatisfiedConditions) {
        String selectUnsatisfiedValueIDs = "SELECT " + this.serverValueTable + '.' + "id" + " FROM " + this.providerTable + " JOIN " + this.serverValueTable + " on " + this.providerTable + '.' + "id" + "=" + "provider_id" + " LEFT JOIN " + selectSatisfiedConditions + " on (" + "condition_name" + "=q1." + "provided_condition" + " AND " + this.providerTable + '.' + "plugin_id" + "=q1." + "plugin_id" + ')' + " WHERE " + "q1." + "provided_condition" + " IS NULL" + " AND " + "condition_name" + " IS NOT NULL";
        String sql = "DELETE FROM " + this.serverValueTable + " WHERE " + "id" + " IN (" + "SELECT " + "id" + " FROM " + '(' + selectUnsatisfiedValueIDs + ") as ids)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
                statement.setBoolean(2, false);
            }
        };
    }

    private String getSatisfiedConditionsSQL() {
        String reversedCondition = this.dbType == DBType.SQLITE ? "'not_' || provided_condition" : "CONCAT('not_',provided_condition)";
        String selectSatisfiedPositiveConditions = "SELECT provided_condition,plugin_id FROM " + this.providerTable + " JOIN " + this.serverValueTable + " on " + this.providerTable + '.' + "id" + "=" + "provider_id" + " WHERE " + "boolean_value" + "=?" + " AND " + "provided_condition" + " IS NOT NULL";
        String selectSatisfiedNegativeConditions = "SELECT " + reversedCondition + " as " + "provided_condition" + ',' + "plugin_id" + " FROM " + this.providerTable + " JOIN " + this.serverValueTable + " on " + this.providerTable + '.' + "id" + "=" + "provider_id" + " WHERE " + "boolean_value" + "=?" + " AND " + "provided_condition" + " IS NOT NULL";
        return '(' + selectSatisfiedPositiveConditions + " UNION " + selectSatisfiedNegativeConditions + ") q1";
    }

    private Executable deleteUnsatisfiedTableValues(String selectSatisfiedConditions) {
        String selectUnsatisfiedValueIDs = "SELECT id FROM " + this.tableTable + " LEFT JOIN " + selectSatisfiedConditions + " on (" + this.tableTable + '.' + "condition_name" + "=q1." + "provided_condition" + " AND " + this.tableTable + '.' + "plugin_id" + "=q1." + "plugin_id" + ')' + " WHERE " + "q1." + "provided_condition" + " IS NULL" + " AND " + "condition_name" + " IS NOT NULL";
        String deleteValuesSQL = "DELETE FROM " + this.serverTableValueTable + " WHERE " + "table_id" + " IN (" + "SELECT " + "id" + " FROM " + '(' + selectUnsatisfiedValueIDs + ") as ids)";
        return new ExecStatement(deleteValuesSQL){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setBoolean(1, true);
                statement.setBoolean(2, false);
            }
        };
    }
}

