/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.results;

import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.extension.implementation.providers.Parameters;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionProviderTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class StorePlayerDoubleResultTransaction
extends ThrowawayTransaction {
    private final String pluginName;
    private final UUID serverUUID;
    private final String providerName;
    private final UUID playerUUID;
    private final double value;
    private final boolean percentage;

    public StorePlayerDoubleResultTransaction(DataProvider<Double> provider, Parameters parameters, double value) {
        this.pluginName = provider.getProviderInformation().getPluginName();
        this.providerName = provider.getProviderInformation().getName();
        this.serverUUID = parameters.getServerUUID();
        this.playerUUID = parameters.getPlayerUUID();
        this.value = value;
        this.percentage = provider.getProviderInformation().isPercentage();
    }

    @Override
    protected void performOperations() {
        this.execute(this.storeValue());
    }

    private Executable storeValue() {
        return connection -> {
            if (!this.updateValue().execute(connection)) {
                return this.insertValue().execute(connection);
            }
            return false;
        };
    }

    private Executable updateValue() {
        String sql = "UPDATE plan_extension_user_values SET " + (this.percentage ? "percentage_value" : "double_value") + "=?" + " WHERE " + "uuid" + "=?" + " AND " + "provider_id" + "=" + "(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setDouble(1, StorePlayerDoubleResultTransaction.this.value);
                statement.setString(2, StorePlayerDoubleResultTransaction.this.playerUUID.toString());
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 3, StorePlayerDoubleResultTransaction.this.providerName, StorePlayerDoubleResultTransaction.this.pluginName, StorePlayerDoubleResultTransaction.this.serverUUID);
            }
        };
    }

    private Executable insertValue() {
        String sql = "INSERT INTO plan_extension_user_values(" + (this.percentage ? "percentage_value" : "double_value") + "," + "uuid" + "," + "provider_id" + ") VALUES (?,?," + "(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)" + ")";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setDouble(1, StorePlayerDoubleResultTransaction.this.value);
                statement.setString(2, StorePlayerDoubleResultTransaction.this.playerUUID.toString());
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 3, StorePlayerDoubleResultTransaction.this.providerName, StorePlayerDoubleResultTransaction.this.pluginName, StorePlayerDoubleResultTransaction.this.serverUUID);
            }
        };
    }
}

