/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.results;

import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.extension.implementation.providers.Parameters;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionProviderTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;

public class StorePlayerGroupsResultTransaction
extends ThrowawayTransaction {
    private final String pluginName;
    private final UUID serverUUID;
    private final String providerName;
    private final UUID playerUUID;
    private final String[] value;

    public StorePlayerGroupsResultTransaction(DataProvider<String[]> provider, Parameters parameters, String[] value) {
        this.pluginName = provider.getProviderInformation().getPluginName();
        this.providerName = provider.getProviderInformation().getName();
        this.serverUUID = parameters.getServerUUID();
        this.playerUUID = parameters.getPlayerUUID();
        this.value = value;
    }

    @Override
    protected void performOperations() {
        this.execute(this.deleteOldValues());
        for (String group : this.value) {
            String groupName = StringUtils.truncate(group, 50);
            this.execute(this.insertGroup(groupName));
        }
    }

    private Executable deleteOldValues() {
        String sql = "DELETE FROM plan_extension_groups WHERE uuid=? AND provider_id=(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, StorePlayerGroupsResultTransaction.this.playerUUID.toString());
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 2, StorePlayerGroupsResultTransaction.this.providerName, StorePlayerGroupsResultTransaction.this.pluginName, StorePlayerGroupsResultTransaction.this.serverUUID);
            }
        };
    }

    private Executable insertGroup(final String group) {
        String sql = "INSERT INTO plan_extension_groups(group_name,uuid,provider_id) VALUES (?,?,(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1))";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setString(1, group);
                statement.setString(2, StorePlayerGroupsResultTransaction.this.playerUUID.toString());
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 3, StorePlayerGroupsResultTransaction.this.providerName, StorePlayerGroupsResultTransaction.this.pluginName, StorePlayerGroupsResultTransaction.this.serverUUID);
            }
        };
    }
}

