/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.results;

import com.djrapitops.plan.extension.implementation.providers.DataProvider;
import com.djrapitops.plan.extension.implementation.providers.Parameters;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionProviderTable;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;

public class StoreServerNumberResultTransaction
extends ThrowawayTransaction {
    private final String pluginName;
    private final UUID serverUUID;
    private final String providerName;
    private final long value;

    public StoreServerNumberResultTransaction(DataProvider<Long> provider, Parameters parameters, long value) {
        this.pluginName = provider.getProviderInformation().getPluginName();
        this.providerName = provider.getProviderInformation().getName();
        this.serverUUID = parameters.getServerUUID();
        this.value = value;
    }

    @Override
    protected void performOperations() {
        this.execute(this.storeValue());
    }

    private Executable storeValue() {
        return connection -> {
            if (!this.updateValue().execute(connection)) {
                return this.insertValue().execute(connection);
            }
            return false;
        };
    }

    private Executable updateValue() {
        String sql = "UPDATE plan_extension_server_values SET long_value=? WHERE provider_id=(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1)";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, StoreServerNumberResultTransaction.this.value);
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 2, StoreServerNumberResultTransaction.this.providerName, StoreServerNumberResultTransaction.this.pluginName, StoreServerNumberResultTransaction.this.serverUUID);
            }
        };
    }

    private Executable insertValue() {
        String sql = "INSERT INTO plan_extension_server_values(long_value,provider_id) VALUES (?,(SELECT id FROM plan_extension_providers WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1))";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setLong(1, StoreServerNumberResultTransaction.this.value);
                ExtensionProviderTable.set3PluginValuesToStatement(statement, 2, StoreServerNumberResultTransaction.this.providerName, StoreServerNumberResultTransaction.this.pluginName, StoreServerNumberResultTransaction.this.serverUUID);
            }
        };
    }
}

