/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.implementation.storage.transactions.results;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.extension.table.Table;
import com.djrapitops.plan.storage.database.queries.Query;
import com.djrapitops.plan.storage.database.queries.QueryStatement;
import com.djrapitops.plan.storage.database.sql.tables.ExtensionTableProviderTable;
import com.djrapitops.plan.storage.database.transactions.ExecBatchStatement;
import com.djrapitops.plan.storage.database.transactions.ExecStatement;
import com.djrapitops.plan.storage.database.transactions.Executable;
import com.djrapitops.plan.storage.database.transactions.ThrowawayTransaction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;

public class StoreServerTableResultTransaction
extends ThrowawayTransaction {
    private final String pluginName;
    private final UUID serverUUID;
    private final String providerName;
    private final Table table;

    public StoreServerTableResultTransaction(String pluginName, UUID serverUUID, String providerName, Table table) {
        this.pluginName = pluginName;
        this.serverUUID = serverUUID;
        this.providerName = providerName;
        this.table = table;
    }

    @Override
    protected void performOperations() {
        this.execute(this.storeValue());
    }

    private Executable storeValue() {
        return connection -> {
            int maxColumnSize = this.table.getMaxColumnSize();
            if (maxColumnSize == 0) {
                return false;
            }
            Integer tableID = this.query(this.tableID());
            this.deleteOldValues(tableID).execute(connection);
            this.insertNewValues(tableID).execute(connection);
            return false;
        };
    }

    private Executable deleteOldValues(final int tableID) {
        String sql = "DELETE FROM plan_extension_server_table_values WHERE table_id=? AND uuid=?";
        return new ExecStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                statement.setInt(1, tableID);
                statement.setString(2, StoreServerTableResultTransaction.this.serverUUID.toString());
            }
        };
    }

    private Executable insertNewValues(final int tableID) {
        String sql = "INSERT INTO plan_extension_server_table_values(table_id,uuid,col_1_value,col_2_value,col_3_value,col_4_value,col_5_value) VALUES (?,?,?,?,?,?, ?)";
        return new ExecBatchStatement(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                int maxColumnSize = Math.min(StoreServerTableResultTransaction.this.table.getMaxColumnSize(), 5);
                for (Object[] row : StoreServerTableResultTransaction.this.table.getRows()) {
                    int i;
                    statement.setInt(1, tableID);
                    statement.setString(2, StoreServerTableResultTransaction.this.serverUUID.toString());
                    for (i = 0; i < maxColumnSize; ++i) {
                        Object value = row[i];
                        StoreServerTableResultTransaction.this.setStringOrNull(statement, 3 + i, value != null ? StringUtils.truncate(value.toString(), 250) : null);
                    }
                    for (i = maxColumnSize; i < 5; ++i) {
                        statement.setNull(3 + i, 12);
                    }
                    statement.addBatch();
                }
            }
        };
    }

    private void setStringOrNull(PreparedStatement statement, int index, String value) throws SQLException {
        if (value != null) {
            statement.setString(index, value);
        } else {
            statement.setNull(index, 12);
        }
    }

    private Query<Integer> tableID() {
        String sql = "SELECT id FROM plan_extension_tables WHERE name=? AND plugin_id=(SELECT id FROM plan_extension_plugins WHERE name=? AND server_uuid=? LIMIT 1) LIMIT 1";
        return new QueryStatement<Integer>(sql){

            @Override
            public void prepare(PreparedStatement statement) throws SQLException {
                ExtensionTableProviderTable.set3PluginValuesToStatement(statement, 1, StoreServerTableResultTransaction.this.providerName, StoreServerTableResultTransaction.this.pluginName, StoreServerTableResultTransaction.this.serverUUID);
            }

            @Override
            public Integer processResults(ResultSet set) throws SQLException {
                if (set.next()) {
                    int id = set.getInt("id");
                    if (!set.wasNull()) {
                        return id;
                    }
                }
                throw new DBOpException("Table Provider was not saved before storing results. Please report this issue. Extension method: " + StoreServerTableResultTransaction.this.pluginName + "#" + StoreServerTableResultTransaction.this.providerName);
            }
        };
    }
}

