/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.extension.table;

import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.icon.Color;
import com.djrapitops.plan.extension.icon.Icon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plan.org.apache.commons.lang3.StringUtils;

public final class Table {
    private final String[] columns = new String[5];
    private final Icon[] icons = new Icon[5];
    private final List<Object[]> rows = new ArrayList<Object[]>();

    private Table() {
    }

    public static Factory builder() {
        return new Factory();
    }

    public String[] getColumns() {
        return this.columns;
    }

    public int getMaxColumnSize() {
        int columnCount = 0;
        for (String column : this.columns) {
            if (column == null) break;
            ++columnCount;
        }
        return columnCount;
    }

    public Icon[] getIcons() {
        return this.icons;
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    public static final class Factory {
        private final Table building = new Table();
        Color color;
        String tableName;
        String tabName;
        int tabPriority;
        ElementOrder[] tabOrder;
        Icon tabIcon;

        private Factory() {
        }

        private Factory column(int indx, String columnName, Icon icon) {
            ((Table)this.building).columns[indx] = StringUtils.truncate(columnName, 50);
            ((Table)this.building).icons[indx] = icon != null ? Icon.called(icon.getName()).of(icon.getFamily()).build() : Icon.called("question").build();
            return this;
        }

        public Factory columnOne(String columnName, Icon icon) {
            return this.column(0, columnName, icon);
        }

        public Factory columnTwo(String columnName, Icon icon) {
            return this.column(1, columnName, icon);
        }

        public Factory columnThree(String columnName, Icon icon) {
            return this.column(2, columnName, icon);
        }

        public Factory columnFour(String columnName, Icon icon) {
            return this.column(3, columnName, icon);
        }

        public Factory columnFive(String columnName, Icon icon) {
            return this.column(4, columnName, icon);
        }

        public Factory addRow(Object ... values) {
            if (values == null) {
                throw new IllegalArgumentException("'values' for Table#addRow can not be null!");
            }
            if (values.length == 0 || this.areAllValuesNull(values)) {
                return this;
            }
            this.building.rows.add(Arrays.copyOf(values, 5));
            return this;
        }

        private boolean areAllValuesNull(Object[] values) {
            boolean allNull = true;
            for (Object value : values) {
                if (value == null) continue;
                allNull = false;
                break;
            }
            return allNull;
        }

        public Table build() {
            return this.building;
        }
    }
}

