/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.gathering;

import com.djrapitops.plan.Plan;
import com.djrapitops.plan.gathering.ServerSensor;
import com.djrapitops.plugin.api.Check;
import org.bukkit.Server;
import org.bukkit.World;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class BukkitSensor
implements ServerSensor<World> {
    private final Plan plugin;
    private final boolean hasTPSMethod;
    private final boolean hasEntityCountMethod;
    private final boolean hasChunkCountMethod;

    @Inject
    public BukkitSensor(Plan plugin) {
        this.plugin = plugin;
        boolean hasPaper = Check.isPaperAvailable();
        this.hasTPSMethod = hasPaper && this.hasPaperMethod(Server.class, "getTPS");
        this.hasEntityCountMethod = hasPaper && this.hasPaperMethod(World.class, "getEntityCount");
        this.hasChunkCountMethod = hasPaper && this.hasPaperMethod(World.class, "getChunkCount");
    }

    @Override
    public boolean supportsDirectTPS() {
        return this.hasTPSMethod;
    }

    @Override
    public double getTPS() {
        return this.plugin.getServer().getTPS()[0];
    }

    @Override
    public int getChunkCount(World world) {
        if (this.hasChunkCountMethod) {
            try {
                return this.getChunkCountPaperWay(world);
            }
            catch (BootstrapMethodError | NoSuchMethodError linkageError) {
                // empty catch block
            }
        }
        return this.getChunkCountSpigotWay(world);
    }

    private int getChunkCountSpigotWay(World world) {
        return world.getLoadedChunks().length;
    }

    private int getChunkCountPaperWay(World world) {
        return world.getChunkCount();
    }

    @Override
    public int getEntityCount(World world) {
        if (this.hasEntityCountMethod) {
            try {
                return this.getEntitiesPaperWay(world);
            }
            catch (BootstrapMethodError | NoSuchMethodError linkageError) {
                // empty catch block
            }
        }
        return this.getEntitiesSpigotWay(world);
    }

    private int getEntitiesSpigotWay(World world) {
        return world.getEntities().size();
    }

    private int getEntitiesPaperWay(World world) {
        return world.getEntityCount();
    }

    @Override
    public int getOnlinePlayerCount() {
        return this.plugin.getServer().getOnlinePlayers().size();
    }

    @Override
    public Iterable<World> getWorlds() {
        return this.plugin.getServer().getWorlds();
    }

    private boolean hasPaperMethod(Class<?> clazz, String methodName) {
        try {
            return clazz.getMethod(methodName, new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

